<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <h3><?php echo e(__('settings.visit_types')); ?></h3>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <a href="<?php echo e(route('visit_types.create')); ?>" class="btn btn-primary mb-3"><?php echo e(__('forms.create')); ?> <?php echo e(__('settings.visit_types')); ?></a>

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>#</th>
                <th><?php echo e(__('lang.name')); ?></th>
                <th><?php echo e(__('lang.actions')); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $visitTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($vt->id); ?></td>
                    <td><?php echo e($vt->name); ?></td>
                    <td>
                        <a href="<?php echo e(route('visit_types.edit', $vt->id)); ?>" class="btn btn-sm btn-warning"><?php echo e(__('lang.edit')); ?></a>

                        <form action="<?php echo e(route('visit_types.destroy', $vt->id)); ?>" method="POST" style="display:inline-block;">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('<?php echo e(__('forms.confirm_delete')); ?>')"><?php echo e(__('lang.delete')); ?></button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\ZakBE\Documents\Nouveau dossier\prjdossier\waiting-room-app\resources\views/visit_types/index.blade.php ENDPATH**/ ?>