<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <h2 class="mb-4">📊 <?php echo e(__('statistics.queue_statistics')); ?></h2>

    <!-- فلاتر -->
    <form method="GET" class="card p-3 mb-4 shadow-sm">
        <div class="row">
            <div class="col-md-3">
                <label><?php echo e(__('statistics.from_date')); ?></label>
                <input type="date" name="start_date" value="<?php echo e($startDate); ?>" class="form-control">
            </div>
            <div class="col-md-3">
                <label><?php echo e(__('statistics.to_date')); ?></label>
                <input type="date" name="end_date" value="<?php echo e($endDate); ?>" class="form-control">
            </div>
            <div class="col-md-3">
                <label><?php echo e(__('statistics.type')); ?></label>
                <select name="type" class="form-control">
                    <option value=""><?php echo e(__('statistics.all')); ?></option>
                    <option value="appointment" <?php echo e($type=='appointment'?'selected':''); ?>><?php echo e(__('statistics.appointment')); ?></option>
                    <option value="walk-in" <?php echo e($type=='walk-in'?'selected':''); ?>><?php echo e(__('statistics.walk_in_visit')); ?></option>
                </select>
            </div>
            <div class="col-md-3">
                <label><?php echo e(__('statistics.status')); ?></label>
                <select name="status" class="form-control">
                    <option value=""><?php echo e(__('statistics.all')); ?></option>
                    <option value="waiting" <?php echo e($status=='waiting'?'selected':''); ?>><?php echo e(__('statistics.waiting')); ?></option>
                    <option value="serving" <?php echo e($status=='serving'?'selected':''); ?>><?php echo e(__('statistics.serving')); ?></option>
                    <option value="completed" <?php echo e($status=='completed'?'selected':''); ?>><?php echo e(__('statistics.completed')); ?></option>
                    <option value="cancelled" <?php echo e($status=='cancelled'?'selected':''); ?>><?php echo e(__('statistics.cancelled')); ?></option>
                </select>
            </div>
        </div>
        <div class="mt-3 text-end">
            <button class="btn btn-primary"><?php echo e(__('statistics.apply_filter')); ?></button>
        </div>
    </form>

    <!-- الكروت -->
    <div class="row g-3">
        <div class="col-md-2">
            <div class="card shadow-sm text-center p-3">
                <h5 class="text-muted"><?php echo e(__('statistics.total')); ?></h5>
                <h3 class="text-primary"><?php echo e($total); ?></h3>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card shadow-sm text-center p-3">
                <h5 class="text-muted"><?php echo e(__('statistics.waiting')); ?></h5>
                <h3 class="text-warning"><?php echo e($waiting); ?></h3>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card shadow-sm text-center p-3">
                <h5 class="text-muted"><?php echo e(__('statistics.serving')); ?></h5>
                <h3 class="text-info"><?php echo e($serving); ?></h3>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card shadow-sm text-center p-3">
                <h5 class="text-muted"><?php echo e(__('statistics.completed')); ?></h5>
                <h3 class="text-success"><?php echo e($completed); ?></h3>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card shadow-sm text-center p-3">
                <h5 class="text-muted"><?php echo e(__('statistics.cancelled')); ?></h5>
                <h3 class="text-danger"><?php echo e($cancelled); ?></h3>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card shadow-sm text-center p-3">
                <h5 class="text-muted"><?php echo e(__('statistics.average_wait_time')); ?></h5>
                <h3 class="text-dark"><?php echo e(round($avgWait, 1)); ?> د</h3>
            </div>
        </div>
    </div>
    <div class="row g-3">
<!-- Chart: Walk-in vs Appointment by Date -->
<div class="card col-6 mt-4 shadow-sm p-3">
    <h5 class="mb-3"><?php echo e(__('statistics.appointments_vs_walkins_by_date')); ?></h5>
    <canvas id="typeByDateChart"></canvas>
</div>

<!-- Chart: Visit Type by Date -->
<div class="card col-6 mt-4 shadow-sm p-3">
    <h5 class="mb-3"><?php echo e(__('statistics.visit_types_by_date')); ?></h5>
    <canvas id="visitTypeChart"></canvas>
</div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<!-- Chart.js -->
<script>
    // Chart 1: Walk-in vs Appointment by Date (Stacked Bar)
    const byDateType = <?php echo json_encode($byDateType, 15, 512) ?>;

    const dates1 = Object.keys(byDateType);
    const walkinData = dates1.map(d => {
        let row = byDateType[d].find(r => r.type === 'walk-in');
        return row ? row.total : 0;
    });
    const appointmentData = dates1.map(d => {
        let row = byDateType[d].find(r => r.type === 'appointment');
        return row ? row.total : 0;
    });

    new Chart(document.getElementById('typeByDateChart'), {
        type: 'bar',
        data: {
            labels: dates1,
            datasets: [
                {
                    label: '<?php echo e(__('statistics.walk_in_visit')); ?>',
                    data: walkinData,
                    backgroundColor: '#ffc107'
                },
                {
                    label: '<?php echo e(__('statistics.appointment')); ?>',
                    data: appointmentData,
                    backgroundColor: '#007bff'
                }
            ]
        },
        options: {
            responsive: true,
            plugins: {
                tooltip: { mode: 'index', intersect: false },
                title: { display: true, text: '<?php echo e(__('statistics.appointments_vs_walkins')); ?>' }
            },
            scales: {
                x: { stacked: true },
                y: { stacked: true, beginAtZero: true }
            }
        }
    });

    // Chart 2: Visit Type by Date (Stacked Bar)
    const visitByDate = <?php echo json_encode($visitByDate, 15, 512) ?>;

    const dates2 = Object.keys(visitByDate);
    const visitTypes = [...new Set(Object.values(visitByDate).flat().map(r => r.visit_type))];

    const datasets2 = visitTypes.map((vt, idx) => {
        return {
            label: vt,
            data: dates2.map(d => {
                let row = visitByDate[d].find(r => r.visit_type === vt);
                return row ? row.total : 0;
            }),
            backgroundColor: `hsl(${idx * 60}, 70%, 50%)`
        }
    });

    new Chart(document.getElementById('visitTypeChart'), {
        type: 'bar',
        data: {
            labels: dates2,
            datasets: datasets2
        },
        options: {
            responsive: true,
            plugins: {
                tooltip: { mode: 'index', intersect: false },
                title: { display: true, text: '<?php echo e(__('statistics.visit_types_by_date')); ?>' }
            },
            scales: {
                x: { stacked: true },
                y: { stacked: true, beginAtZero: true }
            }
        }
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\ZakBE\Documents\Nouveau dossier\prjdossier\waiting-room-app\resources\views/statistics-advanced.blade.php ENDPATH**/ ?>