<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>" dir="<?php echo e(app()->getLocale() == 'ar' ? 'rtl' : 'ltr'); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="tenant-id" content="<?php echo e(auth()->user()->tenant_id); ?>">

    <title><?php echo $__env->yieldContent('title', __('lang.app_name')); ?></title>

    <!-- Bootstrap CSS RTL -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <!-- Flag Icons -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/flag-icon-css/6.6.6/css/flag-icons.min.css" rel="stylesheet">
    <!-- Google Fonts Arabic -->
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;600;700&display=swap" rel="stylesheet">

    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">




    <style>
        body {
            font-family: 'Cairo', sans-serif;
            background-color: #f8f9fa;
        }

        .navbar-brand {
            font-weight: 700;
            font-size: 1.5rem;
        }

        .card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            transition: transform 0.2s ease-in-out;
        }

        .card:hover {
            transform: translateY(-2px);
        }

        .btn {
            border-radius: 10px;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15);
        }

        .queue-item {
            background: white;
            border-radius: 10px;
            padding: 15px;
            margin-bottom: 10px;
            border-left: 4px solid #007bff;
            transition: all 0.3s ease;
        }

        .queue-item:hover {
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            transform: translateX(-5px);
        }

        .queue-item.appointment {
            border-left-color: #28a745;
        }

        .queue-item.walk-in {
            border-left-color: #ffc107;
        }

        .current-serving {
            background: linear-gradient(135deg, #007bff, #0056b3);
            color: white;
            border-radius: 15px;
            padding: 20px;
            text-align: center;
            margin-bottom: 20px;
        }

        .stats-card {
            background: linear-gradient(135deg, #28a745, #20c997);
            color: white;
            border-radius: 15px;
            padding: 20px;
            text-align: center;
            margin-bottom: 15px;
        }

        .stats-card h3 {
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 5px;
        }

        .next-btn {
            background: linear-gradient(135deg, #dc3545, #c82333);
            border: none;
            color: white;
            font-size: 1.2rem;
            padding: 15px 30px;
            border-radius: 50px;
            box-shadow: 0 4px 15px rgba(220, 53, 69, 0.3);
            transition: all 0.3s ease;
        }

        .next-btn:hover {
            background: linear-gradient(135deg, #c82333, #a71e2a);
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(220, 53, 69, 0.4);
        }

        .sidebar {
            background: linear-gradient(180deg, #343a40, #495057);
            min-height: 100vh;
            padding-top: 20px;
        }

        .sidebar .nav-link {
            color: #adb5bd;
            padding: 12px 20px;
            margin-bottom: 5px;
            border-radius: 10px;
            transition: all 0.3s ease;
        }

        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            background-color: #007bff;
            color: white;
            transform: translateX(5px);
        }

        .sidebar .nav-link i {
            margin-left: 10px;
            width: 20px;
            text-align: center;
        }

        /* Language Switcher Styles */
        .language-switcher .btn {
            transition: all 0.3s ease;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
        }
        
        .language-switcher .btn:hover {
            background: rgba(255, 255, 255, 0.2);
            transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
        }
        
        .language-switcher .dropdown-menu {
            backdrop-filter: blur(10px);
            background: rgba(255, 255, 255, 0.95);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        
        .language-switcher .dropdown-item {
            border-radius: 6px;
            margin: 2px 6px;
        }
        
        .language-switcher .dropdown-item:hover {
            background: linear-gradient(135deg, #007bff, #0056b3);
            color: white;
            transform: translateX(5px);
        }
        
        .language-switcher .dropdown-item:hover span {
            color: white;
        }
        
        .language-switcher .dropdown-item:hover .fa-arrow-right {
            opacity: 1 !important;
            color: white !important;
        }
        
        /* Flag Icon Styling */
        .fi {
            width: 1.5em;
            height: 1.1em;
            display: inline-block;
            border-radius: 2px;
            box-shadow: 0 1px 2px rgba(0,0,0,0.2);
        }
        
        .language-switcher .fi {
            vertical-align: middle;
        }

        @media (max-width: 768px) {
            .sidebar {
                min-height: auto;
                padding-top: 10px;
            }

            .queue-item {
                margin-bottom: 8px;
                padding: 12px;
            }

            .stats-card h3 {
                font-size: 2rem;
            }
            
            .language-switcher .btn {
                padding: 6px 10px;
                font-size: 0.9rem;
            }
        }
    </style>

    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container-fluid">
            <a class="navbar-brand" href="<?php echo e(route('dashboard')); ?>">
                <i class="fas fa-users me-2"></i>
                <?php echo e(__('lang.waiting_room_management')); ?>

            </a>

            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse justify-content-between align-items-center" id="navbarNav">
                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('dashboard') ? 'active' : ''); ?>" href="<?php echo e(route('dashboard')); ?>">
                            <i class="fas fa-tachometer-alt me-1"></i>
                            <?php echo e(__('lang.dashboard')); ?>

                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('displays.*') ? 'active' : ''); ?>" href="<?php echo e(route('displays.index')); ?>">
                            <i class="fas fa-tv me-1"></i>
                            <?php echo e(__('displays.title')); ?>

                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('join-requests.*') ? 'active' : ''); ?>" href="<?php echo e(route('join-requests.index')); ?>" id="joinRequestsLink">
                            <i class="fas fa-clipboard-list me-1"></i>
                            <?php echo e(__('Join Requests')); ?>

                            <span class="badge bg-warning rounded-pill ms-1" id="joinRequestsBadge" style="display: none;">0</span>
                        </a>
                    </li>
                    <?php if(auth()->user()->isAdmin()): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('users.*') ? 'active' : ''); ?>" href="<?php echo e(route('users.index')); ?>">
                            <i class="fas fa-users-cog me-1"></i>
                            <?php echo e(__('lang.user_management')); ?>

                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('settings') ? 'active' : ''); ?>" href="<?php echo e(route('settings.index')); ?>">
                            <i class="fa-solid fa-gear me-1"></i>
                            <?php echo e(__('lang.settings')); ?>

                        </a>
                    </li>
                    <?php endif; ?>
                </ul>

                <div class="d-flex align-items-center gap-3">
                    <!-- Language Switcher -->
                    <div class="nav-item">
                        <?php echo $__env->make('components.language-switcher', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    
                    <!-- User Dropdown -->
                    <div class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="fas fa-user me-1"></i>
                            <?php echo e(auth()->user()->name); ?>

                        </a>
                        <ul class="dropdown-menu dropdown-menu-end shadow-lg" style="border-radius: 10px; border: none;">
                            <li><a class="dropdown-item py-2" href="<?php echo e(route('profile')); ?>">
                                <i class="fas fa-user-edit me-2"></i><?php echo e(__('lang.profile')); ?>

                            </a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li>
                                <form method="POST" action="<?php echo e(route('logout')); ?>" class="d-inline">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="dropdown-item py-2">
                                        <i class="fas fa-sign-out-alt me-2"></i><?php echo e(__('lang.logout')); ?>

                                    </button>
                                </form>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <div class="container-fluid">
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show mt-3" role="alert">
                <i class="fas fa-check-circle me-2"></i>
                <?php echo e(session('success')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show mt-3" role="alert">
                <i class="fas fa-exclamation-circle me-2"></i>
                <?php echo e(session('error')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <?php echo $__env->yieldContent('content'); ?>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/ably@1.4.14/dist/ably.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/pusher-js@8.4.0/dist/web/pusher.min.js"></script>


    <script>
        // CSRF Token Setup
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        // Auto-hide alerts after 5 seconds
        setTimeout(function() {
            $('.alert').fadeOut('slow');
        }, 5000);
        
        // Update join requests notification badge
        function updateJoinRequestsBadge() {
            fetch('/join-requests/api/pending-count')
                .then(response => response.json())
                .then(data => {
                    const badge = document.getElementById('joinRequestsBadge');
                    if (badge && data.pending_count !== undefined) {
                        if (data.pending_count > 0) {
                            badge.textContent = data.pending_count;
                            badge.style.display = 'inline';
                        } else {
                            badge.style.display = 'none';
                        }
                    }
                })
                .catch(error => console.error('Error updating join requests badge:', error));
        }
        
        // Update badge on page load and every 30 seconds
        updateJoinRequestsBadge();
        setInterval(updateJoinRequestsBadge, 30000);

        $(document).ready(function () {
        $('#customers-table').DataTable({
            language: {
                    "search": "<?php echo e(__('lang.search')); ?>",
                    "lengthMenu": "<?php echo e(__('lang.show_customers')); ?>",
                    "info": "<?php echo e(__('lang.showing_entries')); ?>",
                    "paginate": {
                        "next": "<?php echo e(__('lang.next')); ?>",
                        "previous": "<?php echo e(__('lang.previous')); ?>"
                    },
                    "zeroRecords": "<?php echo e(__('lang.no_data')); ?>"
                }
        });

        // تحميل بيانات الزبون في الفورم
        $(document).on('click', '.load-customer', function () {
    const id = $(this).data('id');
    fetch(`/customers/${id}`)
        .then(res => res.json())
        .then(data => {
            $('#customer_id').val(data.id);     // <-- هنا نضع ID
            $('#name').val(data.name);
            $('#phone').val(data.phone);
        });
});

        // حذف الزبون
        $(document).on('click', '.delete-customer', function () {
            const id = $(this).data('id');
            if (confirm("<?php echo e(__('lang.remove_user')); ?>")) {
                fetch(`/customers/${id}`, {
                    method: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                        'Accept': 'application/json'
                    }
                })
                .then(res => res.json())
                .then(data => {
                    alert(data.message);
                    location.reload();
                });
            }
        });
    });
    </script>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>

<?php /**PATH C:\Users\zakti\Documents\waiting-room-app\resources\views/layouts/app.blade.php ENDPATH**/ ?>