<?php $__env->startSection('title', __('لوحة التحكم')); ?>

<?php $__env->startSection('content'); ?>
<div class="min-vh-100 fade-in">


    <div class="container-fluid py-5">
        <!-- Current Queues with Enhanced Design -->
        <?php if($currentQueues->count() > 0): ?>
        <div class="mb-6">
            <div class="d-flex align-items-center justify-content-between mb-4">
                <div class="d-flex align-items-center">
                    <div class="bg-primary rounded-circle p-3 me-3">
                        <i class="fas fa-clock text-white fa-lg"></i>
                    </div>
                    <div>
                        <h2 class="h3 fw-bold text-dark mb-1"><?php echo e(__('dashboard.current_queues')); ?></h2>
                        <p class="text-muted mb-0"><?php echo e(__('queue.queue_updated')); ?></p>
                    </div>
                </div>
                <div class="d-flex align-items-center gap-3">
                    <button onclick="refreshQueueList()" class="btn btn-outline-primary btn-sm" title="<?php echo e(__('تحديث')); ?>">
                        <i class="fas fa-sync-alt me-1"></i>
                        <?php echo e(__('تحديث')); ?>

                    </button>
                    <span class="badge bg-success rounded-pill px-3 py-2">
                        <i class="fas fa-users me-1"></i>
                        <?php echo e($currentQueues->count()); ?> <?php echo e(__('طابور نشط')); ?>

                    </span>
                </div>
            </div>
            <div class="row g-4">
                <?php $__currentLoopData = $currentQueues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $queue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-6 col-xl-4">
                    <div class="patient-card" data-tenant-uuid="<?php echo e($queue->tenant->uuid); ?>">
                        <div class="card-body position-relative">
                            <!-- Status Indicator -->
                            <div class="position-absolute top-0 end-0 m-3">
                                <?php if(isset($queue->queue_type) && $queue->queue_type === 'walk-in'): ?>
                                    <div class="queue-position">
                                        <?php echo e($queue->position ?? '?'); ?>

                                    </div>
                                <?php else: ?>
                                    <div class="bg-info text-white rounded-circle d-flex align-items-center justify-content-center"
                                         style="width: 80px; height: 80px; font-size: 0.8rem; font-weight: bold;">
                                        <?php echo e(__('موعد')); ?>

                                    </div>
                                <?php endif; ?>
                            </div>

                            <div class="mb-4">
                                <div class="d-flex align-items-start mb-3">
                                    <div class="flex-grow-1">
                                        <h5 class="fw-bold text-dark mb-2"><?php echo e($queue->tenant->name); ?></h5>
                                        <p class="text-muted small mb-2">
                                            <i class="fas fa-map-marker-alt me-1"></i>
                                            <?php echo e($queue->tenant->address); ?>

                                        </p>
                                        <div class="d-flex align-items-center">
                                            <i class="fas fa-concierge-bell text-primary me-2"></i>
                                            <span class="small text-muted"><?php echo e($queue->visitType->name ?? __('زيارة عامة')); ?></span>
                                            <?php if(isset($queue->queue_type)): ?>
                                                <span class="badge ms-2
                                                    <?php if($queue->queue_type === 'walk-in'): ?> bg-success
                                                    <?php else: ?> bg-info <?php endif; ?>">
                                                    <?php if($queue->queue_type === 'walk-in'): ?>
                                                        <?php echo e(__('زائر عادي')); ?>

                                                    <?php else: ?>
                                                        <?php echo e(__('موعد')); ?>

                                                    <?php endif; ?>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Queue Information Grid -->
                            <div class="row g-3 mb-4">
                                <div class="col-12">
                                    <div class="d-flex align-items-center justify-content-between p-3 bg-light rounded-3">
                                        <div class="d-flex align-items-center">
                                            <i class="fas fa-info-circle text-info me-2"></i>
                                            <span class="small fw-medium"><?php echo e(__('ui.status')); ?></span>
                                        </div>
                                        <span class="
                                            <?php if($queue->status == 'waiting'): ?> status-waiting
                                            <?php elseif($queue->status == 'serving'): ?> status-serving
                                            <?php else: ?> status-completed <?php endif; ?>">
                                            <?php echo e(__($queue->status)); ?>

                                        </span>
                                    </div>
                                </div>

                                <?php if(isset($queue->queue_type) && $queue->queue_type === 'walk-in' && $queue->position): ?>
                                <div class="col-6">
                                    <div class="text-center p-3 bg-primary bg-opacity-10 rounded-3">
                                        <div class="fw-bold text-primary h4 mb-1">#<?php echo e($queue->position); ?></div>
                                    <div class="small text-muted"><?php echo e(__('queue.your_position')); ?></div>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="text-center p-3 bg-success bg-opacity-10 rounded-3">
                                        <div class="fw-bold text-success h4 mb-1"><?php echo e($queue->total_walkins_waiting ?? 0); ?></div>
                                        <div class="small text-muted"><?php echo e(__('statistics.total_customers')); ?></div>
                                    </div>
                                </div>
                                <?php elseif(isset($queue->queue_type) && $queue->queue_type === 'appointment' && $queue->appointment_time): ?>
                                <div class="col-12">
                                    <div class="text-center p-3 bg-info bg-opacity-10 rounded-3">
                                        <div class="fw-bold text-info h5 mb-1">
                                            <?php echo e($queue->appointment_time->format('d/m/Y')); ?>

                                        </div>
                                        <div class="fw-bold text-info h4 mb-1">
                                            <?php echo e($queue->appointment_time->format('H:i')); ?>

                                        </div>
                                        <div class="small text-muted">
                                            <?php if($queue->is_appointment_due ?? false): ?>
                                                <span class="text-success"><?php echo e(__('queue.with_appointment')); ?></span>
                                            <?php else: ?>
                                                <?php echo e(__('queue.with_appointment')); ?>

                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                <?php endif; ?>


                                <div class="col-12">
                                    <div class="d-flex align-items-center justify-content-between p-2 rounded-3" style="background-color: rgba(0, 123, 255, 0.05);">
                                        <div class="d-flex align-items-center">
                                            <i class="fas fa-clock text-secondary me-2"></i>
                                            <span class="small text-muted"><?php echo e(__('queue.arrival_time')); ?></span>
                                        </div>
                                        <span class="small fw-medium text-dark"><?php echo e($queue->arrival_time->format('H:i')); ?></span>
                                    </div>
                                </div>
                            </div>

                            <!-- Action Buttons -->
                            <div class="d-flex gap-3">
                                <a href="<?php echo e(route('patient.clinic.show', $queue->tenant->uuid)); ?>"
                                   class="btn btn-patient-secondary flex-grow-1 d-flex align-items-center justify-content-center">
                                    <i class="fas fa-eye me-2"></i>
                                    <?php echo e(__('ui.view_details')); ?>

                                </a>
                                <button onclick="leaveQueue('<?php echo e($queue->tenant->uuid); ?>')"
                                        class="btn btn-patient-danger px-4"
                                        title="<?php echo e(__('queue.removed_from_queue')); ?>">
                                    <i class="fas fa-sign-out-alt"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <?php endif; ?>

        <!-- Favorite Clinics -->
        <?php if($favoriteTenants->count() > 0): ?>
        <div class="mt-5">
            <div class="d-flex align-items-center justify-content-between mb-4">
                <h2 class="h4 fw-semibold text-dark mb-0">
                    <i class="fas fa-heart text-danger me-2"></i>
                    <?php echo e(__('dashboard.favorite_places')); ?>

                </h2>
                <a href="<?php echo e(route('patient.favorites')); ?>" class="btn btn-sm btn-outline-primary"><?php echo e(__('عرض الكل')); ?></a>
            </div>
            <div class="row g-4">
                <?php $__currentLoopData = $favoriteTenants->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tenant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-6 col-lg-4">
                    <div class="patient-card h-100">
                        <div class="card-body">
                            <div class="d-flex align-items-start justify-content-between mb-3">
                                <div class="flex-grow-1">
                                    <h5 class="fw-semibold text-dark mb-1"><?php echo e($tenant->name); ?></h5>
                                    <p class="text-muted small mb-0"><?php echo e($tenant->address); ?></p>
                                </div>
                                <button class="favorite-btn is-favorite" title="<?php echo e(__('إزالة من المفضلة')); ?>">
                                    <i class="fas fa-heart"></i>
                                </button>
                            </div>

                            <a href="<?php echo e(route('patient.clinic.show', $tenant->uuid)); ?>"
                               class="btn btn-patient-primary w-100">
                                <i class="fas fa-eye me-2"></i>
                                <?php echo e(__('عرض التفاصيل')); ?>

                            </a>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>

<style>
/* Refresh button styles */
.btn-outline-primary:hover .fa-sync-alt {
    transform: rotate(180deg);
    transition: transform 0.3s ease;
}

.btn.btn-success {
    transition: all 0.3s ease;
}

.fa-spinner {
    animation: spin 1s linear infinite;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

/* Enhanced button animations */
.btn {
    transition: all 0.2s ease;
}

.btn:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(0, 123, 255, 0.2);
}
</style>

<script>
// Enhanced queue management with loading states and animations
function leaveQueue(tenantUuid) {
    // Create modern confirmation modal
    if (showConfirmModal('<?php echo e(__("تأكيد المغادرة")); ?>', '<?php echo e(__("هل أنت متأكد من مغادرة هذا الطابور؟ لن تتمكن من استرداد مكانك.")); ?>')) {
        const button = event.target.closest('button');
        const card = button.closest('.patient-card');

        // Show loading state
        showLoadingState(button);
        card.style.opacity = '0.6';

        fetch(`/patient/clinic/${tenantUuid}/leave`, {
            method: 'DELETE',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            }
        })
        .then(response => response.json())
        .then(data => {
            hideLoadingState(button);

            if (data.success) {
                // Animate card removal
                card.style.transform = 'translateX(-100%)';
                card.style.opacity = '0';

                setTimeout(() => {
                    showSuccessToast('<?php echo e(__("تم مغادرة الطابور بنجاح")); ?>');
                    location.reload();
                }, 300);
            } else {
                card.style.opacity = '1';
                showErrorToast(data.message || '<?php echo e(__("حدث خطأ، يرجى المحاولة مرة أخرى")); ?>');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            hideLoadingState(button);
            card.style.opacity = '1';
            showErrorToast('<?php echo e(__("حدث خطأ، يرجى المحاولة مرة أخرى")); ?>');
        });
    }
}

// Enhanced loading states
function showLoadingState(element) {
    const originalHtml = element.innerHTML;
    element.dataset.originalHtml = originalHtml;
    element.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';
    element.disabled = true;
}

function hideLoadingState(element) {
    element.innerHTML = element.dataset.originalHtml;
    element.disabled = false;
}

// Modern confirmation modal
function showConfirmModal(title, message) {
    return confirm(`${title}\n\n${message}`);
}

// Toast notifications
function showSuccessToast(message) {
    showToast(message, 'success');
}

function showErrorToast(message) {
    showToast(message, 'error');
}

function showToast(message, type = 'info') {
    const toast = document.createElement('div');
    toast.className = `alert alert-${type === 'success' ? 'success' : 'danger'} alert-dismissible position-fixed top-0 end-0 m-3`;
    toast.style.zIndex = '9999';
    toast.style.minWidth = '300px';
    toast.innerHTML = `
        <i class="fas fa-${type === 'success' ? 'check-circle' : 'exclamation-circle'} me-2"></i>
        ${message}
        <button type="button" class="btn-close" onclick="this.parentElement.remove()"></button>
    `;

    document.body.appendChild(toast);

    // Auto remove after 5 seconds
    setTimeout(() => {
        if (toast.parentElement) {
            toast.style.opacity = '0';
            toast.style.transform = 'translateX(100%)';
            setTimeout(() => toast.remove(), 300);
        }
    }, 5000);
}

// Queue management functions
function refreshQueueList() {
    const refreshBtn = event.target.closest('button');
    const originalHtml = refreshBtn.innerHTML;

    // Show loading state
    refreshBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-1"></i><?php echo e(__("جارٍ التحديث...")); ?>';
    refreshBtn.disabled = true;

    // Show success animation
    setTimeout(() => {
        refreshBtn.innerHTML = '<i class="fas fa-check me-1"></i><?php echo e(__("تم التحديث")); ?>';
        refreshBtn.classList.add('btn-success');
        refreshBtn.classList.remove('btn-outline-primary');

        setTimeout(() => {
            // Reload the page to get fresh data
            location.reload();
        }, 800);
    }, 1000);
}

// Simple function for any remaining queue status calls
function updateQueueStatus(tenantUuid, cardElement) {
    // This function is now simplified - queue updates happen via manual refresh
    console.log('Queue status update requested for:', tenantUuid);
}

// Initialize page animations and interactions
document.addEventListener('DOMContentLoaded', () => {

    // Add stagger animation to cards
    const cards = document.querySelectorAll('.patient-card, .info-card');
    cards.forEach((card, index) => {
        card.style.animationDelay = `${index * 0.1}s`;
        card.classList.add('fade-in');
    });

    // Add hover effects to quick action items
    const quickActions = document.querySelectorAll('.quick-action-item');
    quickActions.forEach(action => {
        action.addEventListener('mouseenter', function() {
            this.style.transform = 'translateY(-5px)';
            this.style.boxShadow = '0 12px 30px rgba(0, 123, 255, 0.15)';
        });

        action.addEventListener('mouseleave', function() {
            this.style.transform = 'translateY(0)';
            this.style.boxShadow = 'none';
        });
    });

    // Smooth scroll for internal links
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            const target = document.querySelector(this.getAttribute('href'));
            if (target) {
                target.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });

    // Add ripple effect to buttons
    document.querySelectorAll('.btn').forEach(button => {
        button.addEventListener('click', createRipple);
    });
});

// Ripple effect for buttons
function createRipple(event) {
    const button = event.currentTarget;
    const circle = document.createElement('span');
    const diameter = Math.max(button.clientWidth, button.clientHeight);
    const radius = diameter / 2;

    const rect = button.getBoundingClientRect();
    circle.style.width = circle.style.height = `${diameter}px`;
    circle.style.left = `${event.clientX - rect.left - radius}px`;
    circle.style.top = `${event.clientY - rect.top - radius}px`;
    circle.classList.add('ripple');

    const ripple = button.getElementsByClassName('ripple')[0];
    if (ripple) {
        ripple.remove();
    }

    button.appendChild(circle);
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.patient', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\ZakBE\Documents\Nouveau dossier\prjdossier\waiting-room-app\resources\views/patient/dashboard.blade.php ENDPATH**/ ?>