

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0"><?php echo e(__('displays.title')); ?></h1>
            <p class="text-muted"><?php echo e(__('displays.subtitle')); ?></p>
        </div>
        <div>
            <a href="<?php echo e(route('settings.displays')); ?>" class="btn btn-outline-primary">
                <i class="fas fa-cog me-2"></i><?php echo e(__('displays.manage_displays')); ?>

            </a>
            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createDisplayModal">
                <i class="fas fa-plus me-2"></i><?php echo e(__('displays.add_new_display')); ?>

            </button>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="bg-primary bg-gradient rounded-circle p-3">
                                <i class="fas fa-tv text-white"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <div class="fw-bold h4 mb-0"><?php echo e($stats['total']); ?></div>
                            <div class="text-muted small"><?php echo e(__('displays.total_displays')); ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="bg-success bg-gradient rounded-circle p-3">
                                <i class="fas fa-check-circle text-white"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <div class="fw-bold h4 mb-0"><?php echo e($stats['online']); ?></div>
                            <div class="text-muted small"><?php echo e(__('displays.online_displays')); ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="bg-warning bg-gradient rounded-circle p-3">
                                <i class="fas fa-exclamation-triangle text-white"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <div class="fw-bold h4 mb-0"><?php echo e($stats['offline']); ?></div>
                            <div class="text-muted small"><?php echo e(__('displays.offline_displays')); ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="bg-info bg-gradient rounded-circle p-3">
                                <i class="fas fa-clock text-white"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <div class="fw-bold h4 mb-0"><?php echo e($stats['pending']); ?></div>
                            <div class="text-muted small"><?php echo e(__('displays.pending_displays')); ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Displays Table -->
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-white border-0 pb-0">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0"><?php echo e(__('displays.displays_list')); ?></h5>
                <div class="d-flex gap-2">
                    <button type="button" class="btn btn-outline-secondary btn-sm" onclick="refreshDisplays()">
                        <i class="fas fa-refresh me-2"></i><?php echo e(__('displays.refresh')); ?>

                    </button>
                    <div class="dropdown">
                        <button class="btn btn-outline-secondary btn-sm dropdown-toggle" type="button" data-bs-toggle="dropdown">
                            <i class="fas fa-filter me-2"></i><?php echo e(__('displays.filter')); ?>

                        </button>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="#" onclick="filterDisplays('all')"><?php echo e(__('displays.all_displays')); ?></a></li>
                            <li><a class="dropdown-item" href="#" onclick="filterDisplays('online')"><?php echo e(__('displays.online_only')); ?></a></li>
                            <li><a class="dropdown-item" href="#" onclick="filterDisplays('offline')"><?php echo e(__('displays.offline_only')); ?></a></li>
                            <li><a class="dropdown-item" href="#" onclick="filterDisplays('pending')"><?php echo e(__('displays.pending_only')); ?></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <div class="card-body">
            <?php if($displaysWithStatus->count() > 0): ?>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead class="table-light">
                            <tr>
                                <th><?php echo e(__('displays.display_name')); ?></th>
                                <th><?php echo e(__('displays.status')); ?></th>
                                <th><?php echo e(__('displays.last_ip')); ?></th>
                                <th><?php echo e(__('displays.paired_at')); ?></th>
                                <th><?php echo e(__('displays.last_activity')); ?></th>
                                <th><?php echo e(__('displays.actions')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $displaysWithStatus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $display): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr data-status="<?php echo e($display['status']); ?>">
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="bg-light rounded-circle p-2 me-3">
                                                <i class="fas fa-tv text-primary"></i>
                                            </div>
                                            <div>
                                                <div class="fw-semibold"><?php echo e($display['name']); ?></div>
                                                <div class="text-muted small">ID: <?php echo e(Str::limit($display['device_token'], 12, '...')); ?></div>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge bg-<?php echo e($display['status_color']); ?> bg-gradient">
                                            <i class="fas fa-circle me-1" style="font-size: 0.6rem;"></i>
                                            <?php echo e($display['status_text']); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <span class="text-muted"><?php echo e($display['last_ip'] ?: __('displays.no_ip')); ?></span>
                                    </td>
                                    <td>
                                        <?php if($display['paired_at']): ?>
                                            <span class="text-muted"><?php echo e(Carbon\Carbon::parse($display['paired_at'])->diffForHumans()); ?></span>
                                        <?php else: ?>
                                            <span class="text-muted"><?php echo e(__('displays.not_paired')); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <span class="text-muted"><?php echo e($display['updated_at']->diffForHumans()); ?></span>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <!-- Open Display Button - Always available -->
                                            <a href="<?php echo e($display['display_url']); ?>" target="_blank" 
                                               class="btn btn-sm <?php if($display['is_authorized'] === 'oui'): ?> btn-primary <?php else: ?> btn-outline-primary <?php endif; ?>" 
                                               title="<?php echo e(__('displays.open_display')); ?>">
                                                <i class="fas fa-external-link-alt me-1"></i>
                                                <?php if($display['status'] === 'online'): ?>
                                                    <?php echo e(__('displays.open_display')); ?>

                                                <?php elseif($display['is_authorized'] === 'oui'): ?>
                                                    <?php echo e(__('displays.open_display')); ?>

                                                <?php else: ?>
                                                    <?php echo e(__('displays.view_display')); ?>

                                                <?php endif; ?>
                                            </a>
                                            
                                            <?php if($display['is_authorized'] === 'non' || $display['is_authorized'] === 'pending'): ?>
                                                <button type="button" class="btn btn-sm btn-outline-info" 
                                                        onclick="showPairingInfoWithShortLink(<?php echo e(json_encode($display)); ?>)" 
                                                        title="<?php echo e(__('displays.show_pairing')); ?>">
                                                    <i class="fas fa-qrcode"></i>
                                                </button>
                                            <?php endif; ?>
                                            
                                            <button type="button" class="btn btn-sm btn-outline-secondary" onclick="editDisplay('<?php echo e($display['id']); ?>', '<?php echo e($display['name']); ?>')" title="<?php echo e(__('displays.edit_display')); ?>">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            
                                            <button type="button" class="btn btn-sm btn-outline-danger" onclick="deleteDisplay('<?php echo e($display['id']); ?>', '<?php echo e($display['name']); ?>')" title="<?php echo e(__('displays.delete_display')); ?>">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="text-center py-5">
                    <i class="fas fa-tv fa-3x text-muted mb-3"></i>
                    <h5 class="text-muted"><?php echo e(__('displays.no_displays')); ?></h5>
                    <p class="text-muted"><?php echo e(__('displays.no_displays_description')); ?></p>
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createDisplayModal">
                        <i class="fas fa-plus me-2"></i><?php echo e(__('displays.add_first_display')); ?>

                    </button>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Create Display Modal -->
<div class="modal fade" id="createDisplayModal" tabindex="-1" aria-labelledby="createDisplayModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="createDisplayModalLabel"><?php echo e(__('displays.add_new_display')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="createDisplayForm">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="displayName" class="form-label"><?php echo e(__('displays.display_name')); ?> <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="displayName" name="name" placeholder="<?php echo e(__('displays.display_name_placeholder')); ?>" required>
                        <div class="form-text"><?php echo e(__('displays.display_name_help')); ?></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('displays.cancel')); ?></button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-plus me-2"></i><?php echo e(__('displays.create_display')); ?>

                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Display Modal -->
<div class="modal fade" id="editDisplayModal" tabindex="-1" aria-labelledby="editDisplayModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editDisplayModalLabel"><?php echo e(__('displays.edit_display')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="editDisplayForm">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <input type="hidden" id="editDisplayId" name="id">
                    <div class="mb-3">
                        <label for="editDisplayName" class="form-label"><?php echo e(__('displays.display_name')); ?> <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="editDisplayName" name="name" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('displays.cancel')); ?></button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-2"></i><?php echo e(__('displays.save_changes')); ?>

                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Pairing Info Modal -->
<div class="modal fade" id="pairingModal" tabindex="-1" aria-labelledby="pairingModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="pairingModalLabel"><?php echo e(__('displays.pairing_information')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="text-center mb-4">
                    <h6><?php echo e(__('displays.pairing_instructions')); ?></h6>
                    <p class="text-muted"><?php echo e(__('displays.pairing_instructions_description')); ?></p>
                </div>
                
                <!-- Short Link Section -->
                <div class="mb-4">
                    <label class="form-label fw-bold text-primary">
                        <i class="fas fa-link me-2"></i><?php echo e(__('displays.short_link')); ?>

                        <span class="badge bg-success ms-2"><?php echo e(__('displays.recommended')); ?></span>
                    </label>
                    <div class="input-group mb-2">
                        <input type="text" class="form-control" id="shortUrlInput" readonly>
                        <button class="btn btn-outline-secondary" type="button" onclick="selectShortUrl()">
                            <i class="fas fa-mouse-pointer"></i>
                        </button>
                        <button class="btn btn-success" type="button" onclick="copyShortUrl()">
                            <i class="fas fa-copy"></i>
                        </button>
                    </div>
                    <div class="form-text text-muted">
                        <i class="fas fa-star me-1"></i><?php echo e(__('displays.short_link_benefits')); ?>

                    </div>
                </div>
                
                <!-- Full URL Section -->
                <div class="mb-3">
                    <label class="form-label fw-bold text-secondary">
                        <i class="fas fa-globe me-2"></i><?php echo e(__('displays.full_url')); ?>

                    </label>
                    <div class="input-group mb-2">
                        <input type="text" class="form-control" id="pairingUrlInput" readonly>
                        <button class="btn btn-outline-secondary" type="button" onclick="selectPairingUrl()">
                            <i class="fas fa-mouse-pointer"></i>
                        </button>
                        <button class="btn btn-primary" type="button" onclick="copyPairingUrl()">
                            <i class="fas fa-copy"></i>
                        </button>
                    </div>
                    <div class="form-text text-muted">
                        <i class="fas fa-info-circle me-1"></i><?php echo e(__('displays.manual_copy_hint')); ?>

                    </div>
                </div>
                
                <!-- Analytics Info -->
                <div id="shortLinkAnalytics" class="alert alert-info" style="display: none;">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <strong><?php echo e(__('displays.link_analytics')); ?>:</strong>
                            <span id="clickCount">0</span> <?php echo e(__('displays.clicks')); ?>

                        </div>
                        <button class="btn btn-sm btn-outline-info" onclick="regenerateShortLink()">
                            <i class="fas fa-refresh me-1"></i><?php echo e(__('displays.regenerate')); ?>

                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
// Auto-refresh displays every 30 seconds
setInterval(refreshDisplays, 30000);

function refreshDisplays() {
    window.location.reload();
}

function filterDisplays(status) {
    const rows = document.querySelectorAll('tbody tr[data-status]');
    rows.forEach(row => {
        const rowStatus = row.getAttribute('data-status');
        if (status === 'all' || rowStatus === status) {
            row.style.display = '';
        } else {
            row.style.display = 'none';
        }
    });
}

function editDisplay(id, name) {
    document.getElementById('editDisplayId').value = id;
    document.getElementById('editDisplayName').value = name;
    new bootstrap.Modal(document.getElementById('editDisplayModal')).show();
}

function deleteDisplay(id, name) {
    if (confirm(`<?php echo e(__('displays.confirm_delete')); ?>: ${name}?`)) {
        // Show loading state on button
        const button = event.target;
        const originalHTML = button.innerHTML;
        button.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';
        button.disabled = true;
        
        fetch(`/displays/${id}`, {
            method: 'DELETE',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Show success message
                alert(data.message || 'Display deleted successfully!');
                // Refresh the page to update the display list
                window.location.reload();
            } else {
                // Show error message
                alert(data.message || 'Failed to delete display');
                // Restore button state
                button.innerHTML = originalHTML;
                button.disabled = false;
            }
        })
        .catch(error => {
            console.error('Delete error:', error);
            alert('An error occurred while deleting the display');
            // Restore button state
            button.innerHTML = originalHTML;
            button.disabled = false;
        });
    }
}

let currentDisplayData = null;

function showPairingInfo(url) {
    document.getElementById('pairingUrlInput').value = url;
    
    // Find the display data from the current row
    const displayRow = event.target.closest('tr');
    if (displayRow) {
        const displayId = displayRow.dataset.displayId;
        // Get display data from somewhere (you might need to store this in data attributes)
        // For now, we'll use a simple approach
    }
    
    new bootstrap.Modal(document.getElementById('pairingModal')).show();
}

function showPairingInfoWithShortLink(displayData) {
    currentDisplayData = displayData;
    
    // Set the full URL
    document.getElementById('pairingUrlInput').value = displayData.pairing_url;
    
    // Set the short URL if available
    if (displayData.short_link && displayData.short_link.short_url) {
        document.getElementById('shortUrlInput').value = displayData.short_link.short_url;
        document.getElementById('clickCount').textContent = displayData.short_link.click_count || 0;
        document.getElementById('shortLinkAnalytics').style.display = 'block';
    } else {
        document.getElementById('shortUrlInput').value = 'Generating...';
        document.getElementById('shortLinkAnalytics').style.display = 'none';
        // Could generate short link here via AJAX
    }
    
    new bootstrap.Modal(document.getElementById('pairingModal')).show();
}

function selectPairingUrl() {
    const input = document.getElementById('pairingUrlInput');
    input.select();
    input.setSelectionRange(0, 99999); // For mobile devices
}

function selectShortUrl() {
    const input = document.getElementById('shortUrlInput');
    input.select();
    input.setSelectionRange(0, 99999); // For mobile devices
}

function copyPairingUrl() {
    const url = document.getElementById('pairingUrlInput').value;
    const btn = event.target;
    const originalText = btn.innerHTML;
    
    copyToClipboard(url, btn, originalText, '<?php echo e(__("displays.copied")); ?>', '<?php echo e(__("displays.copy_error")); ?>', 'btn-primary', 'btn-success');
}

function copyShortUrl() {
    const url = document.getElementById('shortUrlInput').value;
    const btn = event.target;
    const originalText = btn.innerHTML;
    
    copyToClipboard(url, btn, originalText, '<?php echo e(__("displays.short_url_copied")); ?>', '<?php echo e(__("displays.short_url_copy_error")); ?>', 'btn-success', 'btn-success');
}

// Generic copy to clipboard function
function copyToClipboard(url, btn, originalText, successMessage, errorMessage, originalClass, successClass) {
    // Function to show success message
    function showSuccess() {
        btn.innerHTML = '<i class="fas fa-check me-2"></i>' + successMessage;
        btn.classList.remove(originalClass);
        btn.classList.add(successClass);
        
        setTimeout(() => {
            btn.innerHTML = originalText;
            btn.classList.remove(successClass);
            btn.classList.add(originalClass);
        }, 2000);
    }
    
    // Function to show error message
    function showError() {
        btn.innerHTML = '<i class="fas fa-exclamation-triangle me-2"></i>' + errorMessage;
        btn.classList.remove(originalClass);
        btn.classList.add('btn-warning');
        
        setTimeout(() => {
            btn.innerHTML = originalText;
            btn.classList.remove('btn-warning');
            btn.classList.add(originalClass);
        }, 3000);
    }
    
    // Try modern clipboard API first
    if (navigator.clipboard && navigator.clipboard.writeText) {
        navigator.clipboard.writeText(url).then(() => {
            showSuccess();
        }).catch(() => {
            // Fallback if clipboard API fails
            fallbackCopy(url) ? showSuccess() : showError();
        });
    } else {
        // Use fallback method
        fallbackCopy(url) ? showSuccess() : showError();
    }
}

// Regenerate short link
function regenerateShortLink() {
    if (!currentDisplayData || !currentDisplayData.short_link) {
        alert('No short link to regenerate');
        return;
    }
    
    if (!confirm('<?php echo e(__("displays.confirm_regenerate")); ?>')) {
        return;
    }
    
    fetch(`/short-links/${currentDisplayData.short_link.id}/regenerate`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            'X-Requested-With': 'XMLHttpRequest'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            document.getElementById('shortUrlInput').value = data.short_link.short_url;
            document.getElementById('clickCount').textContent = '0';
            alert('<?php echo e(__("displays.regenerate_success")); ?>');
            // Refresh the page to update the display list
            setTimeout(() => window.location.reload(), 1000);
        } else {
            alert('<?php echo e(__("displays.regenerate_error")); ?>');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('<?php echo e(__("displays.regenerate_error")); ?>');
    });
}

// Fallback copy method for older browsers or non-secure contexts
function fallbackCopy(text) {
    try {
        // Create a temporary textarea element
        const textArea = document.createElement('textarea');
        textArea.value = text;
        textArea.style.position = 'fixed';
        textArea.style.left = '-999999px';
        textArea.style.top = '-999999px';
        document.body.appendChild(textArea);
        textArea.focus();
        textArea.select();
        
        // Try to copy using execCommand
        const result = document.execCommand('copy');
        document.body.removeChild(textArea);
        return result;
    } catch (err) {
        console.error('Fallback copy failed:', err);
        return false;
    }
}

// Handle create display form
document.getElementById('createDisplayForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    
    fetch('<?php echo e(route("displays.store")); ?>', {
        method: 'POST',
        body: formData,
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            'X-Requested-With': 'XMLHttpRequest'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            bootstrap.Modal.getInstance(document.getElementById('createDisplayModal')).hide();
            refreshDisplays();
        } else {
            alert(data.message || '<?php echo e(__("displays.create_error")); ?>');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('<?php echo e(__("displays.create_error")); ?>');
    });
});

// Handle edit display form
document.getElementById('editDisplayForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const displayId = document.getElementById('editDisplayId').value;
    const displayName = formData.get('name');
    
    fetch(`/displays/${displayId}`, {
        method: 'PUT',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            'X-Requested-With': 'XMLHttpRequest'
        },
        body: JSON.stringify({
            name: displayName
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            bootstrap.Modal.getInstance(document.getElementById('editDisplayModal')).hide();
            alert(data.message || 'Display updated successfully!');
            window.location.reload();
        } else {
            alert(data.message || 'Failed to update display');
        }
    })
    .catch(error => {
        console.error('Update error:', error);
        alert('An error occurred while updating the display');
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\ZakBE\Documents\Nouveau dossier\prjdossier\waiting-room-app\resources\views/displays/index.blade.php ENDPATH**/ ?>