<?php $__env->startSection("content"); ?>
<div class="container">
    <div class="row justify-content-center">

        <div class="col-md-6">

            <div class="card mb-4">
                <div class="card-header"><?php echo e(__('customers.registered_customers')); ?></div>
                <div class="card-body">


                    <?php if($customers->count()): ?>
                        <table id="customers-table" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('customers.name')); ?></th>
                                    <th><?php echo e(__('customers.phone')); ?></th>
                                    <th><?php echo e(__('customers.actions')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($customer->name); ?></td>
                                        <td><?php echo e($customer->phone); ?></td>
                                        <td>
                                            <button class="btn btn-sm btn-info load-customer" data-id="<?php echo e($customer->id); ?>"><?php echo e(__('customers.load')); ?></button>
                                            <button class="btn btn-sm btn-danger delete-customer" data-id="<?php echo e($customer->id); ?>"><?php echo e(__('customers.delete')); ?></button>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    <?php else: ?>
                        <p class="text-center text-muted"><?php echo e(__('customers.no_results')); ?></p>
                    <?php endif; ?>

                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card">
                <div class="card-header"><?php echo e(__('appointments.book_appointment')); ?></div>

                <div class="card-body">
                    <?php if(session("success")): ?>
                        <div class="alert alert-success" role="alert">
                            <?php echo e(session("success")); ?>

                        </div>
                    <?php endif; ?>

                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <form method="POST" action="<?php echo e(route("appointments.store")); ?>">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" id="customer_id" name="customer_id">
                        <div class="row mb-3">
                            <label for="name" class="col-md-4 col-form-label text-md-end"><?php echo e(__('appointments.customer_name')); ?></label>

                            <div class="col-md-6">
                                <input id="name" type="text" class="form-control <?php $__errorArgs = ["name"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="name" value="<?php echo e(old("name")); ?>" required autocomplete="name" autofocus>

                                <?php $__errorArgs = ["name"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <label for="phone" class="col-md-4 col-form-label text-md-end"><?php echo e(__('appointments.customer_phone')); ?> (<?php echo e(__('forms.optional_field')); ?>)</label>

                            <div class="col-md-6">
                                <input id="phone" type="text" class="form-control <?php $__errorArgs = ["phone"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="phone" value="<?php echo e(old("phone")); ?>" autocomplete="phone">

                                <?php $__errorArgs = ["phone"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <label for="appointment_date" class="col-md-4 col-form-label text-md-end"><?php echo e(__('appointments.appointment_date')); ?></label>

                            <div class="col-md-6">
                                <input id="appointment_date" type="date" class="form-control <?php $__errorArgs = ["appointment_date"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="appointment_date" value="<?php echo e(old("appointment_date", date('Y-m-d'))); ?>" required min="<?php echo e(date('Y-m-d')); ?>">

                                <?php $__errorArgs = ["appointment_date"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <label for="appointment_time" class="col-md-4 col-form-label text-md-end"><?php echo e(__('appointments.appointment_time')); ?></label>

                            <div class="col-md-6">
                                <select id="appointment_time" class="form-control <?php $__errorArgs = ["appointment_time"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="appointment_time" required>
                                    <option value=""><?php echo e(__('appointments.select_time')); ?></option>
                                    <?php $__currentLoopData = $availableSlots; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($slot); ?>" <?php echo e(old("appointment_time") == $slot ? "selected" : ""); ?>><?php echo e($slot); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>

                                <?php $__errorArgs = ["appointment_time"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                <small class="form-text text-muted">
                                    <?php echo e(__('appointments.interval_info', ['minutes' => $settings->interval_minutes])); ?>

                                </small>
                            </div>
                        </div>

                        <div class="row mb-0">
                            <div class="col-md-6 offset-md-4">
                                <button type="submit" class="btn btn-primary">
                                    <?php echo e(__('appointments.book_appointment')); ?>

                                </button>
                                <a href="<?php echo e(route("dashboard")); ?>" class="btn btn-secondary"><?php echo e(__('forms.cancel')); ?></a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener("DOMContentLoaded", function() {
    const dateInput = document.getElementById("appointment_date");
    const timeSelect = document.getElementById("appointment_time");

    function updateAvailableSlots() {
        const selectedDate = dateInput.value;
        if (!selectedDate) return;

        fetch(`/appointments/available-slots?date=${selectedDate}`)
            .then(response => response.json())
            .then(slots => {
                timeSelect.innerHTML = '<option value=""><?php echo e(__('appointments.select_time')); ?></option>';
                slots.forEach(slot => {
                    const option = document.createElement('option');
                    option.value = slot;
                    option.textContent = slot;
                    timeSelect.appendChild(option);
                });
            })
            .catch(error => {
                console.error('Error fetching available slots:', error);
            });
    }

    dateInput.addEventListener("change", updateAvailableSlots);
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.app", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\zakti\Documents\waiting-room-app\resources\views/appointments/create.blade.php ENDPATH**/ ?>