<?php $__env->startSection("content"); ?>
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

<div class="container mt-4">
    <div class="row justify-content-center">
        <div class="col-md-8">

            <div class="card mb-4">
                <div class="card-header"><?php echo e(__('customers.registered_customers')); ?></div>
                <div class="card-body">


                    <?php if($customers->count()): ?>
                        <table id="customers-table" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('customers.name')); ?></th>
                                    <th><?php echo e(__('customers.phone')); ?></th>
                                    <th><?php echo e(__('customers.actions')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($customer->name); ?></td>
                                        <td><?php echo e($customer->phone); ?></td>
                                        <td>
                                            <button class="btn btn-sm btn-info load-customer" data-id="<?php echo e($customer->id); ?>"><?php echo e(__('customers.load')); ?></button>
                                            <button class="btn btn-sm btn-danger delete-customer" data-id="<?php echo e($customer->id); ?>"><?php echo e(__('customers.delete')); ?></button>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    <?php else: ?>
                        <p class="text-center text-muted"><?php echo e(__('customers.no_results')); ?></p>
                    <?php endif; ?>

                </div>
            </div>
        </div>
        <div class="col-md-4">
                    <!-- <?php echo e(__('customers.customer_form')); ?> -->
                    <div class="card">
                        <div class="card-header"><?php echo e(__('customers.add_new_customer')); ?></div>

                        <div class="card-body">
                            <?php if(session("success")): ?>
                                <div class="alert alert-success" role="alert">
                                    <?php echo e(session("success")); ?>

                                </div>
                            <?php endif; ?>

                            <?php if($errors->any()): ?>
                                <div class="alert alert-danger">
                                    <ul>
                                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><?php echo e($error); ?></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            <?php endif; ?>

                            <form method="POST" action="<?php echo e(route("customers.store")); ?>">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" id="customer_id" name="customer_id">
                                <div class="mb-3 row">
                                    <label for="name" class="col-md-3 col-form-label"><?php echo e(__('customers.name')); ?></label>
                                    <div class="col-md-9">
                                        <input id="name" type="text" class="form-control" name="name" value="<?php echo e(old("name")); ?>" required>
                                    </div>
                                </div>

                                <div class="mb-3 row">
                                    <label for="phone" class="col-md-3 col-form-label"><?php echo e(__('customers.phone')); ?></label>
                                    <div class="col-md-9">
                                        <input id="phone" type="text" class="form-control" name="phone" value="<?php echo e(old("phone")); ?>">
                                    </div>
                                </div>
                                <div class="mb-3 row">
                                    <label for="visit_type" class="col-md-3 col-form-label"><?php echo e(__('customers.visit_type')); ?></label>
                                    <div class="col-md-9">
                                        <select id="visit_type" class="form-control" name="visit_type" required>
                                            <option value=""><?php echo e(__('customers.select_visit_type')); ?></option>
                                            <?php $__currentLoopData = $visitTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vtype): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($vtype->name); ?>" <?php echo e(old('visit_type') == 'consultation' ? 'selected' : ''); ?>><?php echo e($vtype->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>


                                <div class="text-end">
                                    <button type="submit" class="btn btn-primary"><?php echo e(__('customers.add_customer')); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.app", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\zakti\Documents\waiting-room-app\resources\views/customers/create.blade.php ENDPATH**/ ?>