<?php $__env->startSection('content'); ?>
<style>
    .hero-section {
        background: url("https://images.unsplash.com/photo-1588776814546-1ffcf47267d7?ixlib=rb-4.0.3&auto=format&fit=crop&w=1350&q=80") no-repeat center center;
        background-size: cover;
        min-height: 90vh;
        position: relative;
        color: #fff;
    }
    .hero-overlay {
        position: absolute;
        top: 0; left: 0; right: 0; bottom: 0;
        background: rgba(0,0,0,0.6);
    }
    .hero-content {
        position: relative;
        z-index: 2;
    }
</style>

<!-- Hero Section -->
<section class="hero-section d-flex align-items-center text-center">
    <div class="hero-overlay"></div>
    <div class="container hero-content">
        <h1 class="display-3 fw-bold"><?php echo e(__('landing.main_title')); ?></h1>
        <p class="lead mt-3">
            <?php echo e(__('landing.main_subtitle')); ?>

        </p>
        <div class="mt-4">
            <a href="<?php echo e(route('tenants.create')); ?>" class="btn btn-light btn-lg mx-2 shadow">
                <?php echo e(__('landing.try_as_owner')); ?>

            </a>
            <a href="#" class="btn btn-warning btn-lg mx-2 shadow">
                <?php echo e(__('landing.try_as_customer')); ?>

            </a>
        </div>
    </div>
</section>

<!-- Features Section -->
<section class="py-5 bg-light">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="fw-bold text-primary"><?php echo e(__('landing.features_title')); ?></h2>
            <p class="text-muted"><?php echo e(__('landing.features_subtitle')); ?></p>
        </div>
        <div class="row g-4">
            <div class="col-md-6 col-lg-3">
                <div class="card shadow-sm h-100 text-center">
                    <div class="card-body">
                        <div class="mb-3 text-primary fs-2">
                            <i class="bi bi-people-fill"></i>
                        </div>
                        <h5 class="card-title"><?php echo e(__('landing.feature_queue_title')); ?></h5>
                        <p class="card-text text-muted">
                            <?php echo e(__('landing.feature_queue_desc')); ?>

                        </p>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-lg-3">
                <div class="card shadow-sm h-100 text-center">
                    <div class="card-body">
                        <div class="mb-3 text-success fs-2">
                            <i class="bi bi-clock-history"></i>
                        </div>
                        <h5 class="card-title"><?php echo e(__('landing.feature_time_title')); ?></h5>
                        <p class="card-text text-muted">
                            <?php echo e(__('landing.feature_time_desc')); ?>

                        </p>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-lg-3">
                <div class="card shadow-sm h-100 text-center">
                    <div class="card-body">
                        <div class="mb-3 text-warning fs-2">
                            <i class="bi bi-bell-fill"></i>
                        </div>
                        <h5 class="card-title"><?php echo e(__('landing.feature_notifications_title')); ?></h5>
                        <p class="card-text text-muted">
                            <?php echo e(__('landing.feature_notifications_desc')); ?>

                        </p>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-lg-3">
                <div class="card shadow-sm h-100 text-center">
                    <div class="card-body">
                        <div class="mb-3 text-danger fs-2">
                            <i class="bi bi-bar-chart-fill"></i>
                        </div>
                        <h5 class="card-title"><?php echo e(__('landing.feature_stats_title')); ?></h5>
                        <p class="card-text text-muted">
                            <?php echo e(__('landing.feature_stats_desc')); ?>

                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Footer -->
<footer class="bg-dark text-white py-3 mt-5">
    <div class="container text-center">
        <p class="mb-0">&copy; <?php echo e(date('Y')); ?> <?php echo e(__('landing.footer_text')); ?></p>
    </div>
</footer>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\ZakBE\Documents\Nouveau dossier\prjdossier\waiting-room-app\resources\views//land.blade.php ENDPATH**/ ?>