

<?php $__env->startSection('title', __('لوحة التحكم')); ?>

<?php $__env->startSection('content'); ?>
<div class="min-vh-100 fade-in">
    <!-- Enhanced Header with Modern Design -->
    <div class="dashboard-header">
        <div class="container-fluid">
            <div class="row align-items-center py-5">
                <div class="col-lg-8">
                    <div class="d-flex align-items-center mb-3">
                        <div class="me-4">
                            <div class="rounded-circle bg-gradient" style="width: 80px; height: 80px; background: linear-gradient(135deg, #007bff, #28a745); display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-user-circle fa-2x text-white"></i>
                            </div>
                        </div>
                        <div>
                            <h1 class="display-6 fw-bold text-dark mb-2"><?php echo e(__('أهلاً وسهلاً')); ?> <?php echo e($patient->name); ?></h1>
                            <p class="lead text-muted mb-1"><?php echo e(__('مرحباً بك في لوحة التحكم الخاصة بك')); ?></p>
                            <p class="text-muted small mb-0">
                                <i class="fas fa-calendar-alt me-2"></i>
                                <?php echo e(__('اليوم:')); ?> <?php echo e(now()->format('d/m/Y')); ?> - <?php echo e(now()->format('H:i')); ?>

                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 text-lg-end">
                    <div class="d-flex flex-column gap-3">
                        <a href="<?php echo e(route('patient.search')); ?>" 
                           class="btn btn-patient-primary btn-lg">
                            <i class="fas fa-search me-2"></i>
                            <?php echo e(__('البحث عن العيادات')); ?>

                        </a>
                        <a href="<?php echo e(route('patient.search')); ?>" 
                           class="btn btn-patient-secondary">
                            <i class="fas fa-map-marker-alt me-2"></i>
                            <?php echo e(__('ابحث عن عيادة')); ?>

                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container-fluid py-5">
        <!-- Current Queues with Enhanced Design -->
        <?php if($currentQueues->count() > 0): ?>
        <div class="mb-6">
            <div class="d-flex align-items-center justify-content-between mb-4">
                <div class="d-flex align-items-center">
                    <div class="bg-primary rounded-circle p-3 me-3">
                        <i class="fas fa-clock text-white fa-lg"></i>
                    </div>
                    <div>
                        <h2 class="h3 fw-bold text-dark mb-1"><?php echo e(__('طوابير الانتظار الحالية')); ?></h2>
                        <p class="text-muted mb-0"><?php echo e(__('تتبع حالة انتظارك في الوقت الفعلي')); ?></p>
                    </div>
                </div>
                <div class="d-flex align-items-center">
                    <span class="badge bg-success rounded-pill px-3 py-2">
                        <i class="fas fa-users me-1"></i>
                        <?php echo e($currentQueues->count()); ?> <?php echo e(__('طابور نشط')); ?>

                    </span>
                </div>
            </div>
            <div class="row g-4">
                <?php $__currentLoopData = $currentQueues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $queue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-6 col-xl-4">
                    <div class="patient-card" data-tenant-uuid="<?php echo e($queue->tenant->uuid); ?>">
                        <div class="card-body position-relative">
                            <!-- Status Indicator -->
                            <div class="position-absolute top-0 end-0 m-3">
                                <?php if(isset($queue->queue_type) && $queue->queue_type === 'walk-in'): ?>
                                    <div class="queue-position">
                                        <?php echo e($queue->position ?? '?'); ?>

                                    </div>
                                <?php else: ?>
                                    <div class="bg-info text-white rounded-circle d-flex align-items-center justify-content-center" 
                                         style="width: 50px; height: 50px; font-size: 0.8rem; font-weight: bold;">
                                        RDV
                                    </div>
                                <?php endif; ?>
                            </div>
                            
                            <div class="mb-4">
                                <div class="d-flex align-items-start mb-3">
                                    <div class="flex-grow-1">
                                        <h5 class="fw-bold text-dark mb-2"><?php echo e($queue->tenant->name); ?></h5>
                                        <p class="text-muted small mb-2">
                                            <i class="fas fa-map-marker-alt me-1"></i>
                                            <?php echo e($queue->tenant->address); ?>

                                        </p>
                                        <div class="d-flex align-items-center">
                                            <i class="fas fa-stethoscope text-primary me-2"></i>
                                            <span class="small text-muted"><?php echo e($queue->visitType->name ?? __('زيارة عامة')); ?></span>
                                            <?php if(isset($queue->queue_type)): ?>
                                                <span class="badge ms-2 
                                                    <?php if($queue->queue_type === 'walk-in'): ?> bg-success
                                                    <?php else: ?> bg-info <?php endif; ?>">
                                                    <?php if($queue->queue_type === 'walk-in'): ?>
                                                        <?php echo e(__('زائر عادي')); ?>

                                                    <?php else: ?>
                                                        <?php echo e(__('موعد')); ?>

                                                    <?php endif; ?>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Queue Information Grid -->
                            <div class="row g-3 mb-4">
                                <div class="col-12">
                                    <div class="d-flex align-items-center justify-content-between p-3 bg-light rounded-3">
                                        <div class="d-flex align-items-center">
                                            <i class="fas fa-info-circle text-info me-2"></i>
                                            <span class="small fw-medium"><?php echo e(__('الحالة')); ?></span>
                                        </div>
                                        <span class="
                                            <?php if($queue->status == 'waiting'): ?> status-waiting
                                            <?php elseif($queue->status == 'serving'): ?> status-serving
                                            <?php else: ?> status-completed <?php endif; ?>">
                                            <?php echo e(__($queue->status)); ?>

                                        </span>
                                    </div>
                                </div>
                                
                                <?php if(isset($queue->queue_type) && $queue->queue_type === 'walk-in' && $queue->position): ?>
                                <div class="col-6">
                                    <div class="text-center p-3 bg-primary bg-opacity-10 rounded-3">
                                        <div class="fw-bold text-primary h4 mb-1">#<?php echo e($queue->position); ?></div>
                                        <div class="small text-muted"><?php echo e(__('ترتيبك بين الزوار')); ?></div>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="text-center p-3 bg-success bg-opacity-10 rounded-3">
                                        <div class="fw-bold text-success h4 mb-1"><?php echo e($queue->total_walkins_waiting ?? 0); ?></div>
                                        <div class="small text-muted"><?php echo e(__('إجمالي الزوار')); ?></div>
                                    </div>
                                </div>
                                <?php elseif(isset($queue->queue_type) && $queue->queue_type === 'appointment' && $queue->appointment_time): ?>
                                <div class="col-12">
                                    <div class="text-center p-3 bg-info bg-opacity-10 rounded-3">
                                        <div class="fw-bold text-info h5 mb-1">
                                            <?php echo e($queue->appointment_time->format('d/m/Y')); ?>

                                        </div>
                                        <div class="fw-bold text-info h4 mb-1">
                                            <?php echo e($queue->appointment_time->format('H:i')); ?>

                                        </div>
                                        <div class="small text-muted">
                                            <?php if($queue->is_appointment_due ?? false): ?>
                                                <span class="text-success"><?php echo e(__('حان وقت الموعد')); ?></span>
                                            <?php else: ?>
                                                <?php echo e(__('موعد مجدول')); ?>

                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                <?php endif; ?>
                                
                                
                                <div class="col-12">
                                    <div class="d-flex align-items-center justify-content-between p-2 rounded-3" style="background-color: rgba(0, 123, 255, 0.05);">
                                        <div class="d-flex align-items-center">
                                            <i class="fas fa-clock text-secondary me-2"></i>
                                            <span class="small text-muted"><?php echo e(__('وقت الوصول')); ?></span>
                                        </div>
                                        <span class="small fw-medium text-dark"><?php echo e($queue->arrival_time->format('H:i')); ?></span>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Action Buttons -->
                            <div class="d-flex gap-3">
                                <a href="<?php echo e(route('patient.clinic.show', $queue->tenant->uuid)); ?>" 
                                   class="btn btn-patient-secondary flex-grow-1 d-flex align-items-center justify-content-center">
                                    <i class="fas fa-eye me-2"></i>
                                    <?php echo e(__('عرض التفاصيل')); ?>

                                </a>
                                <button onclick="leaveQueue('<?php echo e($queue->tenant->uuid); ?>')" 
                                        class="btn btn-patient-danger px-4"
                                        title="<?php echo e(__('مغادرة الطابور')); ?>">
                                    <i class="fas fa-sign-out-alt"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <?php endif; ?>

        <!-- Statistics Cards -->
        <div class="row g-4 mb-5">
            <div class="col-lg-3 col-md-6">
                <div class="info-card h-100">
                    <div class="card-body text-center">
                        <div class="rounded-circle bg-primary bg-opacity-10 p-3 d-inline-flex mb-3">
                            <i class="fas fa-clock fa-2x text-primary"></i>
                        </div>
                        <h3 class="h2 fw-bold text-primary mb-1"><?php echo e($currentQueues->count()); ?></h3>
                        <p class="text-muted mb-0"><?php echo e(__('طوابير نشطة')); ?></p>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="info-card h-100">
                    <div class="card-body text-center">
                        <div class="rounded-circle bg-success bg-opacity-10 p-3 d-inline-flex mb-3">
                            <i class="fas fa-check-circle fa-2x text-success"></i>
                        </div>
                        <h3 class="h2 fw-bold text-success mb-1"><?php echo e($recentVisits->count()); ?></h3>
                        <p class="text-muted mb-0"><?php echo e(__('زيارات مكتملة')); ?></p>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="info-card h-100">
                    <div class="card-body text-center">
                        <div class="rounded-circle bg-danger bg-opacity-10 p-3 d-inline-flex mb-3">
                            <i class="fas fa-heart fa-2x text-danger"></i>
                        </div>
                        <h3 class="h2 fw-bold text-danger mb-1"><?php echo e($favoriteTenants->count()); ?></h3>
                        <p class="text-muted mb-0"><?php echo e(__('عيادات مفضلة')); ?></p>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="info-card h-100">
                    <div class="card-body text-center">
                        <div class="rounded-circle bg-info bg-opacity-10 p-3 d-inline-flex mb-3">
                            <i class="fas fa-calendar-check fa-2x text-info"></i>
                        </div>
                        <h3 class="h2 fw-bold text-info mb-1"><?php echo e(now()->format('d')); ?></h3>
                        <p class="text-muted mb-0"><?php echo e(__('اليوم من الشهر')); ?></p>
                    </div>
                </div>
            </div>
        </div>

        <div class="row g-4">
            <!-- Enhanced Quick Actions -->
            <div class="col-lg-6">
                <div class="patient-card h-100">
                    <div class="card-body">
                        <div class="d-flex align-items-center mb-4">
                            <div class="bg-gradient rounded-circle p-3 me-3" style="background: linear-gradient(135deg, #007bff, #28a745);">
                                <i class="fas fa-rocket text-white fa-lg"></i>
                            </div>
                            <div>
                                <h2 class="h4 fw-bold text-dark mb-1"><?php echo e(__('إجراءات سريعة')); ?></h2>
                                <p class="text-muted small mb-0"><?php echo e(__('اختر من الإجراءات أدناه')); ?></p>
                            </div>
                        </div>
                        <div class="d-grid gap-3">
                            <a href="<?php echo e(route('patient.search')); ?>" class="quick-action-item p-4 text-decoration-none text-dark">
                                <div class="d-flex align-items-center">
                                    <div class="flex-shrink-0 me-3">
                                        <div class="rounded-circle bg-primary bg-opacity-10 p-3">
                                            <i class="fas fa-search fa-lg text-primary"></i>
                                        </div>
                                    </div>
                                    <div class="flex-grow-1">
                                        <div class="fw-bold mb-1 text-dark"><?php echo e(__('البحث عن العيادات')); ?></div>
                                        <div class="small text-muted"><?php echo e(__('ابحث عن العيادات القريبة منك')); ?></div>
                                    </div>
                                    <div class="flex-shrink-0">
                                        <i class="fas fa-chevron-left text-muted"></i>
                                    </div>
                                </div>
                            </a>
                            
                            <a href="<?php echo e(route('patient.favorites')); ?>" class="quick-action-item p-4 text-decoration-none text-dark">
                                <div class="d-flex align-items-center">
                                    <div class="flex-shrink-0 me-3">
                                        <div class="rounded-circle bg-danger bg-opacity-10 p-3">
                                            <i class="fas fa-heart fa-lg text-danger"></i>
                                        </div>
                                    </div>
                                    <div class="flex-grow-1">
                                        <div class="fw-bold mb-1 text-dark"><?php echo e(__('العيادات المفضلة')); ?></div>
                                        <div class="small text-muted"><?php echo e(__('عرض عياداتك المحفوظة')); ?></div>
                                    </div>
                                    <div class="flex-shrink-0">
                                        <i class="fas fa-chevron-left text-muted"></i>
                                    </div>
                                </div>
                            </a>
                            
                            <a href="<?php echo e(route('patient.history')); ?>" class="quick-action-item p-4 text-decoration-none text-dark">
                                <div class="d-flex align-items-center">
                                    <div class="flex-shrink-0 me-3">
                                        <div class="rounded-circle bg-secondary bg-opacity-10 p-3">
                                            <i class="fas fa-history fa-lg text-secondary"></i>
                                        </div>
                                    </div>
                                    <div class="flex-grow-1">
                                        <div class="fw-bold mb-1 text-dark"><?php echo e(__('سجل الزيارات')); ?></div>
                                        <div class="small text-muted"><?php echo e(__('عرض زياراتك السابقة')); ?></div>
                                    </div>
                                    <div class="flex-shrink-0">
                                        <i class="fas fa-chevron-left text-muted"></i>
                                    </div>
                                </div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Enhanced Recent Visits -->
            <div class="col-lg-6">
                <div class="patient-card h-100">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between mb-4">
                            <div class="d-flex align-items-center">
                                <div class="bg-info bg-opacity-10 rounded-circle p-3 me-3">
                                    <i class="fas fa-clock text-info fa-lg"></i>
                                </div>
                                <div>
                                    <h2 class="h4 fw-bold text-dark mb-1"><?php echo e(__('الزيارات الأخيرة')); ?></h2>
                                    <p class="text-muted small mb-0"><?php echo e(__('آخر زياراتك إلى العيادات')); ?></p>
                                </div>
                            </div>
                            <a href="<?php echo e(route('patient.history')); ?>" class="btn btn-sm btn-outline-primary"><?php echo e(__('عرض الكل')); ?></a>
                        </div>
                        
                        <?php if($recentVisits->count() > 0): ?>
                            <div class="d-grid gap-3">
                                <?php $__currentLoopData = $recentVisits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $visit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="info-card border-0">
                                    <div class="card-body p-3">
                                        <div class="d-flex align-items-center justify-content-between">
                                            <div class="d-flex align-items-center">
                                                <div class="bg-success bg-opacity-10 rounded-circle p-2 me-3">
                                                    <i class="fas fa-clinic-medical text-success"></i>
                                                </div>
                                                <div>
                                                    <div class="fw-bold text-dark mb-1"><?php echo e($visit->tenant->name); ?></div>
                                                    <div class="small text-muted">
                                                        <i class="fas fa-calendar me-1"></i>
                                                        <?php echo e($visit->completed_at->format('d/m/Y H:i')); ?>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="status-completed">
                                                <?php echo e(__('مكتمل')); ?>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php else: ?>
                            <div class="text-center py-5">
                                <div class="bg-light rounded-circle p-4 d-inline-flex mb-3">
                                    <i class="fas fa-file-medical-alt fa-3x text-muted"></i>
                                </div>
                                <h5 class="text-muted mb-2"><?php echo e(__('لا توجد زيارات سابقة')); ?></h5>
                                <p class="text-muted small mb-0"><?php echo e(__('عندما تكمل زياراتك، ستظهر هنا')); ?></p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Favorite Clinics -->
        <?php if($favoriteTenants->count() > 0): ?>
        <div class="mt-5">
            <div class="d-flex align-items-center justify-content-between mb-4">
                <h2 class="h4 fw-semibold text-dark mb-0">
                    <i class="fas fa-heart text-danger me-2"></i>
                    <?php echo e(__('العيادات المفضلة')); ?>

                </h2>
                <a href="<?php echo e(route('patient.favorites')); ?>" class="btn btn-sm btn-outline-primary"><?php echo e(__('عرض الكل')); ?></a>
            </div>
            <div class="row g-4">
                <?php $__currentLoopData = $favoriteTenants->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tenant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-6 col-lg-4">
                    <div class="patient-card h-100">
                        <div class="card-body">
                            <div class="d-flex align-items-start justify-content-between mb-3">
                                <div class="flex-grow-1">
                                    <h5 class="fw-semibold text-dark mb-1"><?php echo e($tenant->name); ?></h5>
                                    <p class="text-muted small mb-0"><?php echo e($tenant->address); ?></p>
                                </div>
                                <button class="favorite-btn is-favorite" title="<?php echo e(__('إزالة من المفضلة')); ?>">
                                    <i class="fas fa-heart"></i>
                                </button>
                            </div>
                            
                            <a href="<?php echo e(route('patient.clinic.show', $tenant->uuid)); ?>" 
                               class="btn btn-patient-primary w-100">
                                <i class="fas fa-eye me-2"></i>
                                <?php echo e(__('عرض التفاصيل')); ?>

                            </a>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>

<script>
// Enhanced queue management with loading states and animations
function leaveQueue(tenantUuid) {
    // Create modern confirmation modal
    if (showConfirmModal('<?php echo e(__("تأكيد المغادرة")); ?>', '<?php echo e(__("هل أنت متأكد من مغادرة هذا الطابور؟ لن تتمكن من استرداد مكانك.")); ?>')) {
        const button = event.target.closest('button');
        const card = button.closest('.patient-card');
        
        // Show loading state
        showLoadingState(button);
        card.style.opacity = '0.6';
        
        fetch(`/patient/clinic/${tenantUuid}/leave`, {
            method: 'DELETE',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            }
        })
        .then(response => response.json())
        .then(data => {
            hideLoadingState(button);
            
            if (data.success) {
                // Animate card removal
                card.style.transform = 'translateX(-100%)';
                card.style.opacity = '0';
                
                setTimeout(() => {
                    showSuccessToast('<?php echo e(__("تم مغادرة الطابور بنجاح")); ?>');
                    location.reload();
                }, 300);
            } else {
                card.style.opacity = '1';
                showErrorToast(data.message || '<?php echo e(__("حدث خطأ، يرجى المحاولة مرة أخرى")); ?>');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            hideLoadingState(button);
            card.style.opacity = '1';
            showErrorToast('<?php echo e(__("حدث خطأ، يرجى المحاولة مرة أخرى")); ?>');
        });
    }
}

// Enhanced loading states
function showLoadingState(element) {
    const originalHtml = element.innerHTML;
    element.dataset.originalHtml = originalHtml;
    element.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';
    element.disabled = true;
}

function hideLoadingState(element) {
    element.innerHTML = element.dataset.originalHtml;
    element.disabled = false;
}

// Modern confirmation modal
function showConfirmModal(title, message) {
    return confirm(`${title}\n\n${message}`);
}

// Toast notifications
function showSuccessToast(message) {
    showToast(message, 'success');
}

function showErrorToast(message) {
    showToast(message, 'error');
}

function showToast(message, type = 'info') {
    const toast = document.createElement('div');
    toast.className = `alert alert-${type === 'success' ? 'success' : 'danger'} alert-dismissible position-fixed top-0 end-0 m-3`;
    toast.style.zIndex = '9999';
    toast.style.minWidth = '300px';
    toast.innerHTML = `
        <i class="fas fa-${type === 'success' ? 'check-circle' : 'exclamation-circle'} me-2"></i>
        ${message}
        <button type="button" class="btn-close" onclick="this.parentElement.remove()"></button>
    `;
    
    document.body.appendChild(toast);
    
    // Auto remove after 5 seconds
    setTimeout(() => {
        if (toast.parentElement) {
            toast.style.opacity = '0';
            toast.style.transform = 'translateX(100%)';
            setTimeout(() => toast.remove(), 300);
        }
    }, 5000);
}

// Enhanced real-time queue status updates
let updateInterval;

function startQueueUpdates() {
    updateInterval = setInterval(() => {
        const queueCards = document.querySelectorAll('[data-tenant-uuid]');
        queueCards.forEach(card => {
            const tenantUuid = card.dataset.tenantUuid;
            updateQueueStatus(tenantUuid, card);
        });
    }, 30000);
}

function updateQueueStatus(tenantUuid, cardElement) {
    // Add subtle loading indicator
    const statusIndicator = cardElement.querySelector('.queue-status-indicator');
    if (statusIndicator) {
        statusIndicator.classList.add('updating');
    }
    
    fetch(`/api/patient/queue-status/${tenantUuid}`)
        .then(response => response.json())
        .then(data => {
            if (data.in_queue) {
                // Handle different types of queue updates
                if (data.type === 'walk-in') {
                    // Animate position changes for walk-in patients
                    const positionElement = cardElement.querySelector('.queue-position');
                    const positionDisplayElement = cardElement.querySelector('.fw-bold.text-primary.h4');
                    
                    if (positionElement && data.position !== positionElement.textContent) {
                        positionElement.style.transform = 'scale(1.2)';
                        positionElement.style.background = 'linear-gradient(135deg, #28a745, #20c997)';
                        
                        setTimeout(() => {
                            positionElement.textContent = data.position;
                            positionElement.style.transform = 'scale(1)';
                            positionElement.style.background = 'linear-gradient(135deg, #007bff, #0056b3)';
                        }, 200);
                    }
                    
                    if (positionDisplayElement && data.position !== positionDisplayElement.textContent.replace('#', '')) {
                        positionDisplayElement.style.transform = 'scale(1.1)';
                        setTimeout(() => {
                            positionDisplayElement.textContent = '#' + data.position;
                            positionDisplayElement.style.transform = 'scale(1)';
                        }, 200);
                    }
                    
                    // Update total walk-ins count if available
                    const totalWalkinsElement = cardElement.querySelector('.fw-bold.text-success.h4');
                    if (totalWalkinsElement && data.total_walkins_waiting !== undefined) {
                        totalWalkinsElement.textContent = data.total_walkins_waiting;
                    }
                }
                // For appointment patients, no position updates needed as they show appointment time
                
                
                // Update status badge if changed
                const statusBadge = cardElement.querySelector('.status-waiting, .status-serving, .status-completed');
                if (statusBadge && !statusBadge.classList.contains(`status-${data.status}`)) {
                    statusBadge.style.transform = 'scale(0)';
                    setTimeout(() => {
                        statusBadge.className = `status-${data.status}`;
                        statusBadge.textContent = data.status;
                        statusBadge.style.transform = 'scale(1)';
                    }, 150);
                }
            }
        })
        .catch(error => {
            console.error('Error updating queue status:', error);
        })
        .finally(() => {
            if (statusIndicator) {
                statusIndicator.classList.remove('updating');
            }
        });
}

// Page visibility API to pause/resume updates
document.addEventListener('visibilitychange', () => {
    if (document.hidden) {
        if (updateInterval) clearInterval(updateInterval);
    } else {
        startQueueUpdates();
    }
});

// Initialize page animations and interactions
document.addEventListener('DOMContentLoaded', () => {
    // Initialize queue updates
    startQueueUpdates();
    
    // Add stagger animation to cards
    const cards = document.querySelectorAll('.patient-card, .info-card');
    cards.forEach((card, index) => {
        card.style.animationDelay = `${index * 0.1}s`;
        card.classList.add('fade-in');
    });
    
    // Add hover effects to quick action items
    const quickActions = document.querySelectorAll('.quick-action-item');
    quickActions.forEach(action => {
        action.addEventListener('mouseenter', function() {
            this.style.transform = 'translateY(-5px)';
            this.style.boxShadow = '0 12px 30px rgba(0, 123, 255, 0.15)';
        });
        
        action.addEventListener('mouseleave', function() {
            this.style.transform = 'translateY(0)';
            this.style.boxShadow = 'none';
        });
    });
    
    // Smooth scroll for internal links
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            const target = document.querySelector(this.getAttribute('href'));
            if (target) {
                target.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });
    
    // Add ripple effect to buttons
    document.querySelectorAll('.btn').forEach(button => {
        button.addEventListener('click', createRipple);
    });
});

// Ripple effect for buttons
function createRipple(event) {
    const button = event.currentTarget;
    const circle = document.createElement('span');
    const diameter = Math.max(button.clientWidth, button.clientHeight);
    const radius = diameter / 2;
    
    const rect = button.getBoundingClientRect();
    circle.style.width = circle.style.height = `${diameter}px`;
    circle.style.left = `${event.clientX - rect.left - radius}px`;
    circle.style.top = `${event.clientY - rect.top - radius}px`;
    circle.classList.add('ripple');
    
    const ripple = button.getElementsByClassName('ripple')[0];
    if (ripple) {
        ripple.remove();
    }
    
    button.appendChild(circle);
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.patient', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\zakti\Documents\waiting-room-app\resources\views/patient/dashboard.blade.php ENDPATH**/ ?>