@extends('layouts.default')

@section('content')
<div class="container mt-4">
    <h3>{{ isset($visitType) ? __('visit_types.edit_type') : __('visit_types.add_new_type') }}</h3>

    <form method="POST" action="{{ isset($visitType) ? route('visit_types.update', $visitType->id) : route('visit_types.store') }}">
        @csrf
        @if(isset($visitType)) @method('PUT') @endif

        <div class="mb-3">
            <label for="name" class="form-label">{{ __('lang.name') }}</label>
            <input type="text" class="form-control" id="name" name="name" value="{{ old('name', $visitType->name ?? '') }}" required>
        </div>

        <button type="submit" class="btn btn-success">{{ isset($visitType) ? __('lang.update') : __('lang.add') }}</button>
        <a href="{{ route('visit_types.index') }}" class="btn btn-secondary">{{ __('lang.back') }}</a>
    </form>
</div>
@endsection
