@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">{{ __('users.user_details') }}</div>

                <div class="card-body">
                    <div class="row mb-3">
                        <label class="col-md-4 col-form-label text-md-end"><strong>{{ __('lang.name') }}:</strong></label>
                        <div class="col-md-6">
                            <p class="form-control-plaintext">{{ $user->name }}</p>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <label class="col-md-4 col-form-label text-md-end"><strong>{{ __('lang.email') }}:</strong></label>
                        <div class="col-md-6">
                            <p class="form-control-plaintext">{{ $user->email }}</p>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <label class="col-md-4 col-form-label text-md-end"><strong>{{ __('lang.role') }}:</strong></label>
                        <div class="col-md-6">
                            <p class="form-control-plaintext">
                                @if($user->role == 'administrateur')
                                    <span class="badge bg-primary">{{ __('roles.admin') }}</span>
                                @else
                                    <span class="badge bg-secondary">{{ __('roles.assistant') }}</span>
                                @endif
                            </p>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <label class="col-md-4 col-form-label text-md-end"><strong>{{ __('lang.status') }}:</strong></label>
                        <div class="col-md-6">
                            <p class="form-control-plaintext">
                                @if($user->is_active)
                                    <span class="badge bg-success">{{ __('lang.active') }}</span>
                                @else
                                    <span class="badge bg-danger">{{ __('lang.inactive') }}</span>
                                @endif
                            </p>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <label class="col-md-4 col-form-label text-md-end"><strong>{{ __('users.created_at') }}:</strong></label>
                        <div class="col-md-6">
                            <p class="form-control-plaintext">{{ $user->created_at->format('Y-m-d H:i:s') }}</p>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <label class="col-md-4 col-form-label text-md-end"><strong>{{ __('users.updated_at') }}:</strong></label>
                        <div class="col-md-6">
                            <p class="form-control-plaintext">{{ $user->updated_at->format('Y-m-d H:i:s') }}</p>
                        </div>
                    </div>

                    <div class="row mb-0">
                        <div class="col-md-6 offset-md-4">
                            <a href="{{ route('users.edit', $user->id) }}" class="btn btn-primary">{{ __('lang.edit') }}</a>
                            <a href="{{ route('users.index') }}" class="btn btn-secondary">{{ __('users.back_to_list') }}</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

