@extends('layouts.app')

@push('styles')

@endpush

@section('content')
<div class="container">
    <h3>{{ __('users.roles_management') }}</h3>

    @if (session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>{{ __('users.user') }}</th>
                <th>{{ __('lang.email') }}</th>
                <th>{{ __('users.roles') }}</th>
                <th>{{ __('lang.edit') }}</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($users as $user)
            <tr>
                <form action="{{ route('users.roles.update', $user->id) }}" method="POST">
                    @csrf
                    <td>{{ $user->name }}</td>
                    <td>{{ $user->email }}</td>
                    <td>
                        <select name="roles[]" multiple class="form-control">
                            @foreach ($roles as $role)
                                <option value="{{ $role->id }}"
                                    {{ $user->roles->contains('id', $role->id) ? 'selected' : '' }}>
                                    {{ $role->name }}
                                </option>
                            @endforeach
                        </select>
                    </td>
                    <td>
                        <button class="btn btn-sm btn-primary">{{ __('lang.update') }}</button>
                    </td>
                </form>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
@push('scripts')

@endpush
