@extends('layouts.app')

@section('title', __('subscriptions.upgrade_plan'))

@section('content')
<style>
    .plan-card {
        transition: all 0.3s ease-in-out;
        border-radius: 20px;
        overflow: hidden;
        position: relative;
    }
    .plan-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 15px 35px rgba(0,0,0,0.15);
    }
    .plan-price {
        font-size: 2.5rem;
        font-weight: bold;
    }
    .plan-feature {
        display: flex;
        align-items: center;
        margin-bottom: 8px;
    }
    .plan-feature svg {
        margin-right: 8px;
        color: #28a745;
    }
    .plan-feature.inactive svg {
        color: #ccc;
    }
    .popular-badge {
        position: absolute;
        top: -12px;
        right: 20px;
        background: #ffc107;
        color: #000;
        padding: 6px 12px;
        font-size: 0.85rem;
        font-weight: bold;
        border-radius: 50px;
        box-shadow: 0 2px 6px rgba(0,0,0,0.15);
    }
    .pulse-btn {
        animation: pulse 1.5s infinite;
    }
    @keyframes pulse {
        0% { box-shadow: 0 0 0 0 rgba(40, 167, 69, 0.7); }
        70% { box-shadow: 0 0 0 12px rgba(40, 167, 69, 0); }
        100% { box-shadow: 0 0 0 0 rgba(40, 167, 69, 0); }
    }
</style>

<div class="container py-5">
    <h1 class="text-center mb-4">🚀 {{ __('subscriptions.choose_your_plan') }}</h1>
    <p class="text-center text-muted mb-5">
        {{ __('subscriptions.plan_selection_subtitle') }}
    </p>

    <div class="row justify-content-center">

        {{-- Free Plan --}}
        <div class="col-md-5 mb-4">
            <div class="card plan-card border-primary shadow-sm h-100">
                <div class="card-header bg-primary text-white text-center py-4">
                    <h3 class="mb-1">{{ __('subscriptions.free_plan') }}</h3>
                    <small>{{ __('subscriptions.suitable_for_beginnings') }}</small>
                </div>
                <div class="card-body">
                    <div class="text-center plan-price text-primary">0.00 DH</div>
                    <hr>
                    <div class="plan-feature"><svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"><path d="M16 2L6 12.01 0 6l1.41-1.41L6 9.17 14.59.59z"/></svg> {{ __('subscriptions.one_user') }}</div>
                    <div class="plan-feature"><svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"><path d="M16 2L6 12.01 0 6l1.41-1.41L6 9.17 14.59.59z"/></svg> {{ __('subscriptions.ten_appointments') }}</div>
                    <div class="plan-feature"><svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"><path d="M16 2L6 12.01 0 6l1.41-1.41L6 9.17 14.59.59z"/></svg> {{ __('subscriptions.twenty_customers') }}</div>
                    <div class="plan-feature inactive"><svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"><path d="M4.646 4.646a.5.5 0 011 0V11.5a.5.5 0 01-1 0V4.646z"/></svg> {{ __('subscriptions.no_sms') }}</div>
                    <div class="plan-feature">📧 {{ __('subscriptions.email_support_only') }}</div>
                    <div class="plan-feature">🏷 {{ __('subscriptions.powered_by_project') }}</div>
                </div>
                <div class="card-footer bg-light text-center">
                    <a href="#" class="btn btn-outline-primary btn-lg w-100">{{ __('subscriptions.choose_plan') }}</a>
                </div>
            </div>
        </div>

        {{-- Business Plan --}}
        <div class="col-md-5 mb-4">
            <div class="card plan-card border-success shadow-sm h-100">
                <div class="popular-badge">{{ __('subscriptions.most_popular') }}</div>
                <div class="card-header bg-success text-white text-center py-4">
                    <h3 class="mb-1">{{ __('subscriptions.business_plan') }}</h3>
                    <small>{{ __('subscriptions.for_professional_use') }}</small>
                </div>
                <div class="card-body">
                    <div class="text-center plan-price text-success">499.00 DH</div>
                    <hr>
                    <div class="plan-feature"><svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"><path d="M16 2L6 12.01 0 6l1.41-1.41L6 9.17 14.59.59z"/></svg> {{ __('subscriptions.fifteen_users') }}</div>
                    <div class="plan-feature"><svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"><path d="M16 2L6 12.01 0 6l1.41-1.41L6 9.17 14.59.59z"/></svg> {{ __('subscriptions.unlimited_customers') }}</div>
                    <div class="plan-feature"><svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"><path d="M16 2L6 12.01 0 6l1.41-1.41L6 9.17 14.59.59z"/></svg> {{ __('subscriptions.five_hundred_sms') }}</div>
                    <div class="plan-feature">💼 {{ __('subscriptions.custom_support') }}</div>
                    <div class="plan-feature">🏷 {{ __('subscriptions.white_label') }}</div>
                    <div class="plan-feature">📊 {{ __('subscriptions.advanced_statistics') }}</div>
                    <div class="plan-feature">👥 {{ __('subscriptions.customer_management_full') }}</div>
                    <div class="plan-feature">🛠 {{ __('subscriptions.user_management_plus_roles') }}</div>
                    <div class="plan-feature">📅 {{ __('subscriptions.integrated_calendar') }}</div>
                    <div class="plan-feature">⚙️ {{ __('subscriptions.advanced_settings') }}</div>
                </div>
                <div class="card-footer bg-light text-center">
                    <a href="#" class="btn btn-success btn-lg w-100 pulse-btn">{{ __('subscriptions.choose_plan') }}</a>
                </div>
            </div>
        </div>

    </div>

    {{-- {{ __('subscriptions.plan_comparison_table') }} --}}
    <h3 class="text-center mt-5 mb-3">📊 {{ __('subscriptions.plan_comparison') }}</h3>
    <div class="table-responsive">
        <table class="table table-bordered text-center">
            <thead class="table-light">
                <tr>
                    <th>{{ __('subscriptions.feature') }}</th>
                    <th>{{ __('subscriptions.free_plan') }}</th>
                    <th>{{ __('subscriptions.business_plan') }}</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>{{ __('subscriptions.number_of_users') }}</td>
                    <td>1</td>
                    <td>15</td>
                </tr>
                <tr>
                    <td>{{ __('subscriptions.number_of_appointments') }}</td>
                    <td>10</td>
                    <td>{{ __('subscriptions.unlimited') }}</td>
                </tr>
                <tr>
                    <td>{{ __('subscriptions.number_of_customers') }}</td>
                    <td>20</td>
                    <td>{{ __('subscriptions.unlimited') }}</td>
                </tr>
                <tr>
                    <td>{{ __('subscriptions.sms_limit') }}</td>
                    <td>0</td>
                    <td>500</td>
                </tr>
                <tr>
                    <td>{{ __('subscriptions.support') }}</td>
                    <td>📧 {{ __('subscriptions.email_only') }}</td>
                    <td>💼 {{ __('subscriptions.custom_support') }}</td>
                </tr>
                <tr>
                    <td>{{ __('subscriptions.branding') }}</td>
                    <td>{{ __('subscriptions.powered_by_project') }}</td>
                    <td>{{ __('subscriptions.white_label') }}</td>
                </tr>
                <tr>
                    <td>{{ __('subscriptions.statistics') }}</td>
                    <td>❌</td>
                    <td>📊 {{ __('subscriptions.advanced') }}</td>
                </tr>
                <tr>
                    <td>{{ __('subscriptions.customer_management') }}</td>
                    <td>{{ __('subscriptions.view_only') }}</td>
                    <td>{{ __('subscriptions.add_edit_delete') }}</td>
                </tr>
                <tr>
                    <td>{{ __('subscriptions.user_management') }}</td>
                    <td>❌</td>
                    <td>✔️</td>
                </tr>
                <tr>
                    <td>{{ __('subscriptions.calendar') }}</td>
                    <td>❌</td>
                    <td>✔️</td>
                </tr>
                <tr>
                    <td>{{ __('subscriptions.advanced_settings') }}</td>
                    <td>❌</td>
                    <td>✔️</td>
                </tr>
            </tbody>
        </table>
    </div>

</div>
@endsection
