@extends('layouts.app')
@section('content')
<div class="container-fluid">
    <h2 class="mb-4">📁 {{ __('statistics.advanced_reports') }}</h2>
    <form method="GET" class="card p-3 mb-4 shadow-sm">
        <div class="row">
            <div class="col-md-3">
                <label>{{ __('statistics.from_date') }}</label>
                <input type="date" name="start_date" value="{{ $startDate }}" class="form-control">
            </div>
            <div class="col-md-3">
                <label>{{ __('statistics.to_date') }}</label>
                <input type="date" name="end_date" value="{{ $endDate }}" class="form-control">
            </div>
            <!-- {{ __('statistics.custom_filters_can_be_added') }} -->
        </div>
        <div class="mt-3 text-end">
            <button class="btn btn-primary">{{ __('statistics.apply_filter') }}</button>
        </div>
    </form>
    <!-- {{ __('statistics.advanced_statistics_charts_here') }} -->
    <div class="row g-3">
        <div class="col-12">
            <div class="card shadow-sm p-3">
                <h4 class="mb-3">{{ __('statistics.advanced_chart_example') }}</h4>
                <canvas id="advancedChart"></canvas>
            </div>
        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    const chartLabels = @json($chartLabels);
    const chartData = @json($chartData);

    new Chart(document.getElementById('advancedChart'), {
        type: 'line',
        data: {
            labels: chartLabels,
            datasets: [{
                label: '{{ __('statistics.custom_data') }}',
                data: chartData,
                borderColor: '#9b59b6',
                fill: false
            }]
        },
        options: {
            responsive: true,
            plugins: {
                title: { display: true, text: '{{ __('statistics.specialized_statistics') }}' }
            },
            scales: { y: { beginAtZero: true } }
        }
    });
</script>
@endsection
