@extends('layouts.default')

@push('css')
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
@endpush

@section('content')
<div class="container py-5">
    <h2 class="mb-4 fw-bold">📊 {{ __('statistics.statistics_dashboard') }}</h2>
    <p class="text-muted mb-5">{{ __('statistics.track_performance') }}</p>

    <div class="row g-4">
        @foreach($stats as $stat)
            <div class="col-md-6 col-lg-4">
                <div class="card shadow-sm border-0 h-100">
                    <div class="card-body text-center p-4">
                        <div class="mb-3">
                            <span class="d-inline-flex justify-content-center align-items-center rounded-circle bg-{{ $stat['color'] }} bg-opacity-10 text-{{ $stat['color'] }}" style="width:70px; height:70px; font-size:30px;">
                                <i class="fas {{ $stat['icon'] }}"></i>
                            </span>
                        </div>
                        <h5 class="card-title fw-bold">{{ $stat['title'] }}</h5>
                        <p class="card-text text-muted small mb-4">{{ $stat['description'] }}</p>
                        <a href="{{ $stat['route'] }}" class="btn btn-{{ $stat['color'] }} w-100">
                            <i class="fas fa-chart-line me-2"></i> {{ __('statistics.view_statistics') }}
                        </a>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
</div>
@endsection
