@extends('layouts.app')
@section('content')
<div class="container-fluid">
    <h2 class="mb-4">💰 {{ __('statistics.revenue_statistics') }}</h2>
    <form method="GET" class="card p-3 mb-4 shadow-sm">
        <div class="row">
            <div class="col-md-3">
                <label>{{ __('statistics.from_date') }}</label>
                <input type="date" name="start_date" value="{{ $startDate }}" class="form-control">
            </div>
            <div class="col-md-3">
                <label>{{ __('statistics.to_date') }}</label>
                <input type="date" name="end_date" value="{{ $endDate }}" class="form-control">
            </div>
        </div>
        <div class="mt-3 text-end">
            <button class="btn btn-primary">{{ __('statistics.apply_filter') }}</button>
        </div>
    </form>
    <div class="row g-3">
        <div class="col-md-3">
            <div class="card shadow-sm text-center p-3">
                <h5 class="text-muted">{{ __('statistics.total_revenue') }}</h5>
                <h3 class="text-primary">{{ number_format($totalRevenue, 0) }}</h3>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card shadow-sm text-center p-3">
                <h5 class="text-muted">{{ __('statistics.daily_average') }}</h5>
                <h3 class="text-success">{{ number_format($averageRevenue, 0) }}</h3>
            </div>
        </div>
    </div>
    <div class="row g-3">
        <div class="card col-12 mt-4 shadow-sm p-3">
            <h5 class="mb-3">{{ __('statistics.daily_revenue_by_period') }}</h5>
            <canvas id="revenuesChart"></canvas>
        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    const chartLabels = @json($chartLabels);
    const chartData = @json($chartData);

    new Chart(document.getElementById('revenuesChart'), {
        type: 'bar',
        data: {
            labels: chartLabels,
            datasets: [{
                label: '{{ __('statistics.revenue') }}',
                data: chartData,
                backgroundColor: '#e67e22'
            }]
        },
        options: {
            responsive: true,
            plugins: {
                title: { display: true, text: '{{ __('statistics.daily_revenue') }}' }
            },
            scales: { y: { beginAtZero: true } }
        }
    });
</script>
@endsection
