@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <h2 class="mb-4">📊 {{ __('statistics.queue_statistics') }}</h2>

    <!-- {{ __('statistics.filters') }} -->
    <form method="GET" class="card p-3 mb-4 shadow-sm">
        <div class="row">
            <div class="col-md-3">
                <label>{{ __('statistics.from_date') }}</label>
                <input type="date" name="start_date" value="{{ $startDate }}" class="form-control">
            </div>
            <div class="col-md-3">
                <label>{{ __('statistics.to_date') }}</label>
                <input type="date" name="end_date" value="{{ $endDate }}" class="form-control">
            </div>
            <div class="col-md-3">
                <label>{{ __('statistics.type') }}</label>
                <select name="type" class="form-control">
                    <option value="">{{ __('statistics.all') }}</option>
                    <option value="appointment" {{ $type=='appointment'?'selected':'' }}>{{ __('statistics.appointment') }}</option>
                    <option value="walk-in" {{ $type=='walk-in'?'selected':'' }}>{{ __('statistics.walk_in') }}</option>
                </select>
            </div>
            <div class="col-md-3">
                <label>{{ __('statistics.status') }}</label>
                <select name="status" class="form-control">
                    <option value="">{{ __('statistics.all') }}</option>
                    <option value="waiting" {{ $status=='waiting'?'selected':'' }}>{{ __('statistics.waiting') }}</option>
                    <option value="serving" {{ $status=='serving'?'selected':'' }}>{{ __('statistics.serving') }}</option>
                    <option value="completed" {{ $status=='completed'?'selected':'' }}>{{ __('statistics.completed') }}</option>
                    <option value="cancelled" {{ $status=='cancelled'?'selected':'' }}>{{ __('statistics.cancelled') }}</option>
                </select>
            </div>
        </div>
        <div class="mt-3 text-end">
            <button class="btn btn-primary">{{ __('statistics.apply_filter') }}</button>
        </div>
    </form>

    <!-- {{ __('statistics.statistical_cards') }} -->
    <div class="row g-3">
        <div class="col-md-2">
            <div class="card shadow-sm text-center p-3">
                <h5 class="text-muted">{{ __('statistics.total') }}</h5>
                <h3 class="text-primary">{{ $total }}</h3>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card shadow-sm text-center p-3">
                <h5 class="text-muted">{{ __('statistics.waiting') }}</h5>
                <h3 class="text-warning">{{ $waiting }}</h3>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card shadow-sm text-center p-3">
                <h5 class="text-muted">{{ __('statistics.serving') }}</h5>
                <h3 class="text-info">{{ $serving }}</h3>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card shadow-sm text-center p-3">
                <h5 class="text-muted">{{ __('statistics.completed') }}</h5>
                <h3 class="text-success">{{ $completed }}</h3>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card shadow-sm text-center p-3">
                <h5 class="text-muted">{{ __('statistics.cancelled') }}</h5>
                <h3 class="text-danger">{{ $cancelled }}</h3>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card shadow-sm text-center p-3">
                <h5 class="text-muted">{{ __('statistics.avg_wait') }}</h5>
                <h3 class="text-dark">{{ round($avgWait, 1) }} {{ __('statistics.minutes') }}</h3>
            </div>
        </div>
    </div>
    <div class="row g-3">
        <!-- Chart: Walk-in vs Appointment by Date -->
        <div class="card col-6 mt-4 shadow-sm p-3">
            <h5 class="mb-3">{{ __('statistics.appointments_vs_walkins_by_date') }}</h5>
            <canvas id="typeByDateChart"></canvas>
        </div>

        <!-- Chart: Visit Type by Date -->
        <div class="card col-6 mt-4 shadow-sm p-3">
            <h5 class="mb-3">{{ __('statistics.visit_types_by_date') }}</h5>
            <canvas id="visitTypeChart"></canvas>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // Chart 1: Walk-in vs Appointment by Date (Stacked Bar)
    const byDateType = @json($byDateType);

    const dates1 = Object.keys(byDateType);
    const walkinData = dates1.map(d => {
        let row = byDateType[d].find(r => r.type === 'walk-in');
        return row ? row.total : 0;
    });
    const appointmentData = dates1.map(d => {
        let row = byDateType[d].find(r => r.type === 'appointment');
        return row ? row.total : 0;
    });

    new Chart(document.getElementById('typeByDateChart'), {
        type: 'bar',
        data: {
            labels: dates1,
            datasets: [
                {
                    label: '{{ __('statistics.walk_in') }}',
                    data: walkinData,
                    backgroundColor: '#ffc107'
                },
                {
                    label: '{{ __('statistics.appointment') }}',
                    data: appointmentData,
                    backgroundColor: '#007bff'
                }
            ]
        },
        options: {
            responsive: true,
            plugins: {
                tooltip: { mode: 'index', intersect: false },
                title: { display: true, text: '{{ __('statistics.appointments_vs_walkins') }}' }
            },
            scales: {
                x: { stacked: true },
                y: { stacked: true, beginAtZero: true }
            }
        }
    });

    // Chart 2: Visit Type by Date (Stacked Bar)
    const visitByDate = @json($visitByDate);

    const dates2 = Object.keys(visitByDate);
    const visitTypes = [...new Set(Object.values(visitByDate).flat().map(r => r.visit_type))];

    const datasets2 = visitTypes.map((vt, idx) => {
        return {
            label: vt,
            data: dates2.map(d => {
                let row = visitByDate[d].find(r => r.visit_type === vt);
                return row ? row.total : 0;
            }),
            backgroundColor: `hsl(${idx * 60}, 70%, 50%)`
        }
    });

    new Chart(document.getElementById('visitTypeChart'), {
        type: 'bar',
        data: {
            labels: dates2,
            datasets: datasets2
        },
        options: {
            responsive: true,
            plugins: {
                tooltip: { mode: 'index', intersect: false },
                title: { display: true, text: '{{ __('statistics.visit_types_by_date') }}' }
            },
            scales: {
                x: { stacked: true },
                y: { stacked: true, beginAtZero: true }
            }
        }
    });
</script>
@endsection
