@extends("layouts.app")

@section("content")
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-10">
            <div class="card">
                <div class="card-header">{{ __('statistics.title') }}</div>

                <div class="card-body">
                    <form method="GET" action="{{ route("statistics.index") }}" class="mb-4">
                        <div class="row">
                            <div class="col-md-4">
                                <label for="start_date" class="form-label">{{ __('statistics.from_date') }}:</label>
                                <input type="date" class="form-control" id="start_date" name="start_date" value="{{ $startDate }}">
                            </div>
                            <div class="col-md-4">
                                <label for="end_date" class="form-label">{{ __('statistics.to_date') }}:</label>
                                <input type="date" class="form-control" id="end_date" name="end_date" value="{{ $endDate }}">
                            </div>
                            <div class="col-md-4 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary">{{ __('statistics.apply_filter') }}</button>
                            </div>
                        </div>
                    </form>

                    <div class="row text-center mb-4">
                        <div class="col-md-3">
                            <div class="card bg-info text-white">
                                <div class="card-body">
                                    <h5 class="card-title">{{ __('statistics.total_customers') }}</h5>
                                    <p class="card-text fs-3">{{ $totalCustomers }}</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card bg-success text-white">
                                <div class="card-body">
                                    <h5 class="card-title">{{ __('statistics.served_today') }}</h5>
                                    <p class="card-text fs-3">{{ $servedCustomers }}</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card bg-warning text-dark">
                                <div class="card-body">
                                    <h5 class="card-title">{{ __('statistics.walk_ins') }}</h5>
                                    <p class="card-text fs-3">{{ $walkInCustomers }}</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card bg-danger text-white">
                                <div class="card-body">
                                    <h5 class="card-title">{{ __('lang.appointments') }}</h5>
                                    <p class="card-text fs-3">{{ $appointmentCustomers }}</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row text-center mb-4">
                        <div class="col-md-12">
                            <div class="card bg-primary text-white">
                                <div class="card-body">
                                    <h5 class="card-title">{{ __('statistics.average_wait_time') }}</h5>
                                    <p class="card-text fs-3">{{ number_format($avgWaitingTime, 2) }}</p>
                                </div>
                            </div>
                        </div>
                    </div>

        <h4>{{ __('statistics.daily_stats') }}</h4>
        @if(empty($dailyStats))
            <p>{{ __('statistics.no_data_available') }}</p>
        @else
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>{{ __('forms.date') }}</th>
                                    <th>{{ __('statistics.total_customers') }}</th>
                                    <th>{{ __('statistics.served_today') }}</th>
                                    <th>{{ __('statistics.walk_ins') }}</th>
                                    <th>{{ __('lang.appointments') }}</th>
                                    <th>{{ __('statistics.average_wait_time') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($dailyStats as $stat)
                                    <tr>
                                        <td>{{ $stat->date }}</td>
                                        <td>{{ $stat->total_customers }}</td>
                                        <td>{{ $stat->served_customers }}</td>
                                        <td>{{ $stat->walk_in_customers }}</td>
                                        <td>{{ $stat->appointment_customers }}</td>
                                        <td>{{ number_format($stat->avg_waiting_time, 2) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
