@extends('layouts.app')
@section('content')
<div class="container-fluid">
    <h2 class="mb-4">📊 {{ __('statistics.customer_statistics') }}</h2>
    <!-- الفلاتر -->
    <form method="GET" class="card p-3 mb-4 shadow-sm">
        <div class="row">
            <div class="col-md-3">
                <label>{{ __('statistics.from_date') }}</label>
                <input type="date" name="start_date" value="{{ $startDate }}" class="form-control">
            </div>
            <div class="col-md-3">
                <label>{{ __('statistics.to_date') }}</label>
                <input type="date" name="end_date" value="{{ $endDate }}" class="form-control">
            </div>
        </div>
        <div class="mt-3 text-end">
            <button class="btn btn-primary">{{ __('statistics.apply_filter') }}</button>
        </div>
    </form>

    <!-- البطاقات -->
    <div class="row g-3">
        <div class="col-md-3">
            <div class="card shadow-sm text-center p-3">
                <h5 class="text-muted">{{ __('statistics.new_in_period') }}</h5>
                <h3 class="text-primary">{{ $newCustomers }}</h3>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card shadow-sm text-center p-3">
                <h5 class="text-muted">{{ __('statistics.total_customers') }}</h5>
                <h3 class="text-success">{{ $allCustomers }}</h3>
            </div>
        </div>
    </div>

    <!-- الشارت -->
    <div class="row g-3">
        <div class="card col-12 mt-4 shadow-sm p-3">
            <h5 class="mb-3">{{ __('statistics.new_customers_by_date') }}</h5>
            <canvas id="customersChart"></canvas>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    const chartLabels = @json($chartLabels);
    const chartData = @json($chartData);

    new Chart(document.getElementById('customersChart'), {
        type: 'bar',
        data: {
            labels: chartLabels,
            datasets: [{
                label: '{{ __('statistics.new') }}',
                data: chartData,
                backgroundColor: '#007bff'
            }]
        },
        options: {
            responsive: true,
            plugins: {
                title: { display: true, text: '{{ __('statistics.new_customers_by_date') }}' }
            },
            scales: { y: { beginAtZero: true } }
        }
    });
</script>
@endsection
