@extends('layouts.default')

@push('css')
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
@endpush

@section('content')
<div class="container py-5">
    <h2 class="mb-4 fw-bold">⚙️ {{ __('settings.title') }}</h2>
    <p class="text-muted mb-5">{{ __('settings.general_settings') }}</p>

    <div class="row g-4">
        @foreach($settings as $setting)
            <div class="col-md-6 col-lg-4">
                <div class="card shadow-sm border-0 h-100">
                    <div class="card-body text-center p-4">
                        <div class="mb-3">
                            <span class="d-inline-flex justify-content-center align-items-center rounded-circle bg-{{ $setting['color'] }} bg-opacity-10 text-{{ $setting['color'] }}" style="width:70px; height:70px; font-size:30px;">
                                <i class="fas {{ $setting['icon'] }}"></i>
                            </span>
                        </div>
                        <h5 class="card-title fw-bold">{{ $setting['title'] }}</h5>
                        <p class="card-text text-muted small mb-4">{{ $setting['description'] }}</p>
                        <a href="{{ $setting['route'] }}" class="btn btn-{{ $setting['color'] }} w-100">
                            <i class="fas fa-arrow-right me-2"></i> {{ __('forms.view') }}
                        </a>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
</div>
@endsection
