@extends('layouts.app')

@section('content')
<div class="container">
    <h3>{{ __('settings.displays') }}</h3>
    <form method="POST" action="{{ url('/settings/displays/create') }}">
        @csrf
        <button class="btn btn-success mb-3">➕ {{ __('settings.create_new_display') }}</button>
    </form>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>{{ __('lang.name') }}</th>
                <th>{{ __('settings.token') }}</th>
                <th>{{ __('settings.display_link') }}</th>
            </tr>
        </thead>
        <tbody>
            @foreach($displays as $display)
            <tr>
                <td>{{ $display->name }}</td>
                <td>{{ $display->device_token }}</td>
                <td><a href="{{ url('/display/'.$display->device_token) }}" target="_blank">{{ __('settings.view_display') }}</a></td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
