@extends('layouts.app')

@section('content')
<div class="container">
    <h3>{{ __('roles.edit_permissions_for_role') }}: {{ $role->name }}</h3>

    <form action="{{ route('roles.permissions.update', $role->id) }}" method="POST">
        @csrf

        @php
            $grouped = $permissions->groupBy('group');
        @endphp

        @foreach ($grouped as $groupName => $perms)
            <div class="card mb-3">
                <div class="card-header">
                    <strong>{{ strtoupper($groupName) }}</strong>
                </div>
                <div class="card-body row">
                    @foreach ($perms as $permission)
                        <div class="col-md-4">
                            <div class="form-check">
                                <input class="form-check-input"
                                    type="checkbox"
                                    name="permissions[]"
                                    value="{{ $permission->id }}"
                                    id="perm_{{ $permission->id }}"
                                    {{ in_array($permission->id, $rolePermissions) ? 'checked' : '' }}>
                                <label class="form-check-label" for="perm_{{ $permission->id }}">
                                    {{ $permission->name }}
                                </label>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        @endforeach

        <button class="btn btn-primary">{{ __('roles.save_changes') }}</button>
        <a href="{{ route('roles.index') }}" class="btn btn-secondary">{{ __('roles.back') }}</a>
    </form>
</div>
@endsection
