@extends('layouts.app')

@section('content')
<div class="container">
    <h2 class="mb-4 text-center">{{ __('roles.create_new_user_with_role') }}</h2>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <form method="POST" action="{{ route('roles.store_with_user') }}" id="wizardForm">
        @csrf

        <!-- {{ __('roles.step_1_select_role') }} -->
        <div class="wizard-step active" id="step-1">
            <h4 class="mb-3">{{ __('roles.step_1_select_role') }}</h4>
            <div class="mb-3">
                <label class="form-label">{{ __('roles.select_existing_role') }}:</label>
                <select name="existing_role_id" class="form-control">
                    <option value="">{{ __('roles.none_create_new') }}</option>
                    @foreach($existingRoles as $role)
                        <option value="{{ $role->id }}">{{ $role->name }}</option>
                    @endforeach
                </select>
            </div>

            <div class="mb-3">
                <label class="form-label">{{ __('roles.or_new_role_name') }}:</label>
                <input type="text" name="role_name" class="form-control">
            </div>

            <button type="button" class="btn btn-primary next-step">{{ __('roles.next') }}</button>
        </div>

        <!-- {{ __('roles.step_2_user_data') }} -->
        <div class="wizard-step d-none" id="step-2">
            <h4 class="mb-3">{{ __('roles.step_2_user_data') }}</h4>
            <div class="mb-3">
                <input type="text" name="user_name" placeholder="{{ __('roles.username') }}" class="form-control">
            </div>
            <div class="mb-3">
                <input type="email" name="user_email" placeholder="{{ __('roles.email') }}" class="form-control">
            </div>
            <div class="mb-3">
                <input type="password" name="user_password" placeholder="{{ __('roles.password') }}" class="form-control">
            </div>

            <button type="button" class="btn btn-secondary prev-step">{{ __('roles.back') }}</button>
            <button type="button" class="btn btn-primary next-step">{{ __('roles.next') }}</button>
        </div>

        <!-- {{ __('roles.step_3_permissions') }} -->
        <div class="wizard-step d-none" id="step-3">
            <h4 class="mb-3">{{ __('roles.step_3_permissions') }}</h4>
            <small class="text-muted">{{ __('roles.select_permissions_if_new_role') }}</small>
            <div class="mt-3">
                @foreach($permissions as $group => $groupPermissions)
                    <h5 class="mt-3">{{ $group }}</h5>
                    <div class="row">
                        @foreach($groupPermissions as $perm)
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input type="checkbox" name="permissions[]" value="{{ $perm->id }}" class="form-check-input" id="perm_{{ $perm->id }}">
                                    <label for="perm_{{ $perm->id }}" class="form-check-label">{{ $perm->name }}</label>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @endforeach
            </div>

            <button type="button" class="btn btn-secondary prev-step">{{ __('roles.back') }}</button>
            <button type="submit" class="btn btn-success">{{ __('roles.finish_and_save') }}</button>
        </div>
    </form>
</div>

<!-- {{ __('roles.wizard_control_javascript') }} -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const steps = document.querySelectorAll('.wizard-step');
        let currentStep = 0;

        function showStep(index) {
            steps.forEach((step, i) => {
                step.classList.toggle('d-none', i !== index);
                step.classList.toggle('active', i === index);
            });
        }

        document.querySelectorAll('.next-step').forEach(btn => {
            btn.addEventListener('click', () => {
                if (currentStep < steps.length - 1) {
                    currentStep++;
                    showStep(currentStep);
                }
            });
        });

        document.querySelectorAll('.prev-step').forEach(btn => {
            btn.addEventListener('click', () => {
                if (currentStep > 0) {
                    currentStep--;
                    showStep(currentStep);
                }
            });
        });

        showStep(currentStep);
    });
</script>
@endsection
