@extends('layouts.app')

@section('content')
<div style="padding: 20px;">
    <h2>QueueUpdated Event Test</h2>

    @if(session('status'))
        <div style="color: green;">{{ session('status') }}</div>
    @endif

    <form method="POST" action="/queue-test/send">
        @csrf
        <button type="submit">Send QueueUpdated Event</button>
    </form>

    <div id="log" style="margin-top: 20px; padding: 10px; border: 1px solid #ccc;">
        Waiting for events...
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/ably@1.4.14/dist/ably.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/pusher-js@8.4.0/dist/web/pusher.min.js"></script>
@vite(['resources/js/app.js'])

<script>
     document.addEventListener('DOMContentLoaded', function() {
    const tenantId = document.querySelector('meta[name="tenant-id"]').getAttribute('content');

    window.Echo.private(`waiting-room.${tenantId}`)
        .listen('QueueUpdated', (e) => {
            const log = document.getElementById('log');
            const time = new Date().toLocaleTimeString();
            log.innerHTML += `<div>[${time}] Queue updated at: ${e.updated}</div>`;
        });
    });
</script>
@endpush
