@extends('layouts.app')

@section('content')
<div class="container">
    <h2 class="mb-4">{{ __('plans.manage_plans') }}</h2>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <table class="table table-bordered table-hover">
        <thead class="table-light">
            <tr>
                <th>#</th>
                <th>{{ __('plans.plan_name') }}</th>
                <th>{{ __('plans.description') }}</th>
                <th>{{ __('plans.price') }}</th>
                <th>{{ __('plans.duration_days') }}</th>
                <th>{{ __('lang.actions') }}</th>
            </tr>
        </thead>
        <tbody>
            @forelse($plans as $plan)
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td>{{ $plan->name }}</td>
                    <td>{{ $plan->description }}</td>
                    <td>{{ $plan->price }} {{ $plan->currency ?? 'MAD' }}</td>
                    <td>{{ $plan->duration_days }}</td>
                    <td>
                        <a href="{{ route('plans.edit-permissions', $plan) }}" class="btn btn-sm btn-primary">
                            <i class="fas fa-key"></i> {{ __('plans.edit_permissions') }}
                        </a>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="6" class="text-center">{{ __('plans.no_plans') }}</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>
@endsection
