@extends('layouts.app')

@section('content')
<div class="container">
    <h2>{{ __('plans.edit_plan_permissions') }}: {{ $plan->name }}</h2>

    <form action="{{ route('plan-permissions.update', $plan->id) }}" method="POST">
        @csrf
        @foreach($permissions as $group => $groupPermissions)
            <h5 class="mt-4">{{ $group }}</h5>
            <div class="row">
                @foreach($groupPermissions as $permission)
                    <div class="col-md-4">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="permissions[]" value="{{ $permission->id }}"
                                {{ in_array($permission->id, $selectedPermissions) ? 'checked' : '' }}>
                            <label class="form-check-label">{{ $permission->name }}</label>
                        </div>
                    </div>
                @endforeach
            </div>
        @endforeach

        <button type="submit" class="btn btn-success mt-3">{{ __('plans.save_changes') }}</button>
        <a href="{{ route('plan-permissions.index') }}" class="btn btn-secondary mt-3">{{ __('lang.back') }}</a>
    </form>
</div>
@endsection
