@extends('layouts.app')

@section('content')
<div class="container">
    <h3>{{ __('plans.edit_permissions_for_role') }}: {{ $role->name }}</h3>
    <form method="POST" action="{{ route('roles.update-permissions', $role->id) }}">
        @csrf
        @method('PUT')

        @foreach($permissions as $group => $groupPermissions)
            <h5>{{ $group }}</h5>
            <div class="row">
                @foreach ($groupPermissions as $permission)
                    <div class="col-md-4">
                        <div class="form-check">
                            <input class="form-check-input"
                                   type="checkbox"
                                   name="permissions[]"
                                   value="{{ $permission->id }}"
                                   id="perm_{{ $permission->id }}"
                                   {{ in_array($permission->id, $rolePermissions) ? 'checked' : '' }}>
                            <label class="form-check-label" for="perm_{{ $permission->id }}">
                                {{ $permission->name }}
                            </label>
                        </div>
                    </div>
                @endforeach
            </div>
            <hr>
        @endforeach

        <button class="btn btn-primary">{{ __('lang.save') }}</button>
    </form>
</div>
@endsection
