@extends('layouts.patient')

@section('title', __('customers.service_history'))

@section('content')
<div class="min-vh-100 bg-light">
    <!-- Header -->
    <div class="bg-white shadow-sm">
        <div class="container py-4">
            <div class="d-flex align-items-center justify-content-between">
                <div class="d-flex align-items-center">
                    <a href="{{ route('patient.dashboard') }}" class="text-muted me-3 text-decoration-none">
                        <svg width="24" height="24" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                        </svg>
                    </a>
                    <div>
                        <h1 class="fs-3 fw-bold text-dark mb-1">{{ __('customers.service_history') }}</h1>
                        <p class="small text-muted mb-0">{{ __('تاريخ خدماتك السابقة والحالية') }}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container py-4">
        <!-- Filter and Stats -->
        <div class="row g-4 mb-4">
            <!-- Visit Stats -->
            <div class="col-lg-8">
                <div class="row g-3">
                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-body text-center">
                        <h3 class="fs-2 fw-bold text-primary mb-1">{{ $visits->total() ?? 0 }}</h3>
                        <p class="small text-muted mb-0">{{ __('إجمالي الخدمات') }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-body text-center">
                                <h3 class="fs-2 fw-bold text-success mb-1">0</h3>
                                <p class="small text-muted mb-0">{{ __('ui.completed') }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-body text-center">
                                <h3 class="fs-2 fw-bold text-warning mb-1">0</h3>
                                <p class="small text-muted mb-0">{{ __('خدمات قادمة') }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Filter -->
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title fs-6 fw-semibold mb-3">{{ __('تصفية النتائج') }}</h5>
                        <div class="mb-3">
                            <label for="statusFilter" class="form-label">{{ __('الحالة') }}</label>
                            <select class="form-select" id="statusFilter">
                                <option value="">{{ __('جميع الخدمات') }}</option>
                                <option value="completed">{{ __('ui.completed') }}</option>
                                <option value="upcoming">{{ __('statistics.upcoming') }}</option>
                                <option value="cancelled">{{ __('ملغية') }}</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="dateFrom" class="form-label">{{ __('من تاريخ') }}</label>
                            <input type="date" class="form-control" id="dateFrom">
                        </div>
                        <div class="mb-3">
                            <label for="dateTo" class="form-label">{{ __('إلى تاريخ') }}</label>
                            <input type="date" class="form-control" id="dateTo">
                        </div>
                        <button type="button" class="btn btn-primary w-100" onclick="applyFilters()">
                            {{ __('تطبيق الفلتر') }}
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Visit History -->
        <div class="card">
            <div class="card-header">
                <h3 class="fs-5 fw-semibold mb-0">{{ __('customers.service_history') }}</h3>
            </div>
            <div class="card-body">
                <div id="visitHistory">
                    @if($visits->count() > 0)
                        @foreach($visits as $visit)
                        <div class="border rounded p-4 mb-3 bg-white">
                            <div class="d-flex justify-content-between align-items-start mb-3">
                                <div>
                                    <h5 class="fs-6 fw-semibold mb-1">{{ $visit->tenant->name }}</h5>
                                    <p class="text-muted small mb-0">{{ $visit->tenant->address ?: __('العنوان غير محدد') }}</p>
                                </div>
                                <span class="badge 
                                    @if($visit->status == 'completed') bg-success
                                    @elseif($visit->status == 'waiting') bg-warning
                                    @elseif($visit->status == 'serving') bg-info
                                    @else bg-secondary
                                    @endif">
                                    @if($visit->status == 'completed') {{ __('ui.completed') }}
                                    @elseif($visit->status == 'waiting') {{ __('ui.waiting') }}
                                    @elseif($visit->status == 'serving') {{ __('ui.serving') }}
                                    @else {{ __($visit->status) }}
                                    @endif
                                </span>
                            </div>
                            <div class="row g-3">
                                <div class="col-md-3">
<small class="text-muted">{{ __('ui.service_date') }}</small>
                                    <p class="mb-0">{{ $visit->arrival_time->format('d M Y') }}</p>
                                </div>
                                <div class="col-md-3">
<small class="text-muted">{{ __('queue.arrival_time') }}</small>
                                    <p class="mb-0">{{ $visit->arrival_time->format('H:i') }}</p>
                                </div>
                                <div class="col-md-3">
<small class="text-muted">{{ __('customers.visit_type') }}</small>
<p class="mb-0">{{ $visit->visit_type ?: __('ui.not_specified') }}</p>
                                </div>
                                <div class="col-md-3">
<small class="text-muted">{{ __('ui.wait_duration') }}</small>
                                    <p class="mb-0">
                                        @if($visit->served_at && $visit->arrival_time)
                                            {{ $visit->arrival_time->diffInMinutes($visit->served_at) }} {{ __('دقيقة') }}
                                        @else
                                            -
                                        @endif
                                    </p>
                                </div>
                            </div>
                            @if($visit->notes)
                            <div class="mt-3">
                                <small class="text-muted">{{ __('ملاحظات') }}</small>
                                <p class="mb-0">{{ $visit->notes }}</p>
                            </div>
                            @endif
                        </div>
                        @endforeach
                        
                        <!-- Pagination -->
                        @if($visits->hasPages())
                        <div class="mt-4">
                            {{ $visits->links() }}
                        </div>
                        @endif
                    @else
                        <!-- Empty state -->
                        <div class="text-center py-5">
                            <svg class="text-muted mb-3" width="64" height="64" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                            </svg>
                <h3 class="fs-5 fw-semibold text-muted mb-2">{{ __('ui.no_services_yet') }}</h3>
                            <p class="text-muted mb-4">{{ __('عندما تقوم بزيارة الأماكن ستظهر هنا') }}</p>
                            <a href="{{ route('patient.search') }}" class="btn btn-primary">
{{ __('ui.find_places') }}
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Sample Visit Entry (hidden by default, for demo purposes) -->
        <div class="d-none" id="sampleVisit">
            <div class="border rounded p-4 mb-3 bg-white">
                <div class="d-flex justify-content-between align-items-start mb-3">
                    <div>
                        <h5 class="fs-6 fw-semibold mb-1">{{ __('عيادة الأسنان المتطورة') }}</h5>
                        <p class="text-muted small mb-0">{{ __('د. أحمد محمد - أخصائي أسنان') }}</p>
                    </div>
                    <span class="badge bg-success">{{ __('مكتملة') }}</span>
                </div>
                <div class="row g-3">
                    <div class="col-md-3">
                        <small class="text-muted">{{ __('تاريخ الزيارة') }}</small>
                        <p class="mb-0">15 مارس 2024</p>
                    </div>
                    <div class="col-md-3">
                        <small class="text-muted">{{ __('وقت الوصول') }}</small>
                        <p class="mb-0">10:30 ص</p>
                    </div>
                    <div class="col-md-3">
                        <small class="text-muted">{{ __('نوع الزيارة') }}</small>
                        <p class="mb-0">{{ __('فحص دوري') }}</p>
                    </div>
                    <div class="col-md-3">
                        <small class="text-muted">{{ __('مدة الانتظار') }}</small>
                        <p class="mb-0">15 دقيقة</p>
                    </div>
                </div>
                <div class="mt-3">
                    <small class="text-muted">{{ __('ملاحظات') }}</small>
                    <p class="mb-0">{{ __('فحص عام - حالة الأسنان جيدة') }}</p>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
function applyFilters() {
    const status = document.getElementById('statusFilter').value;
    const dateFrom = document.getElementById('dateFrom').value;
    const dateTo = document.getElementById('dateTo').value;
    
    // Show loading state
    document.getElementById('visitHistory').innerHTML = `
        <div class="text-center py-5">
            <div class="spinner-border text-primary" role="status">
                <span class="visually-hidden">{{ __('جاري التحميل...') }}</span>
            </div>
            <p class="mt-3 text-muted">{{ __('جاري تحميل سجل الزيارات...') }}</p>
        </div>
    `;
    
    // Simulate loading (in real implementation, this would make an AJAX call)
    setTimeout(() => {
        document.getElementById('visitHistory').innerHTML = `
            <div class="text-center py-5">
                <svg class="text-muted mb-3" width="64" height="64" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                </svg>
                <h3 class="fs-5 fw-semibold text-muted mb-2">{{ __('ui.no_results') }}</h3>
                <p class="text-muted mb-4">{{ __('لا توجد زيارات تطابق المعايير المحددة') }}</p>
                <button class="btn btn-outline-primary" onclick="clearFilters()">
                    {{ __('إلغاء الفلتر') }}
                </button>
            </div>
        `;
    }, 1000);
}

function clearFilters() {
    document.getElementById('statusFilter').value = '';
    document.getElementById('dateFrom').value = '';
    document.getElementById('dateTo').value = '';
    
    // Reset to empty state
    document.getElementById('visitHistory').innerHTML = `
        <div class="text-center py-5">
            <svg class="text-muted mb-3" width="64" height="64" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
            </svg>
            <h3 class="fs-5 fw-semibold text-muted mb-2">{{ __('لا توجد زيارات بعد') }}</h3>
            <p class="text-muted mb-4">{{ __('عندما تقوم بزيارة الأماكن ستظهر هنا') }}</p>
            <a href="{{ route('patient.search') }}" class="btn btn-primary">
                {{ __('ابحث عن مكان') }}
            </a>
        </div>
    `;
}
</script>
@endpush
@endsection