@extends('layouts.patient')

@section('title', __('الأماكن المفضلة'))

@section('content')
<div class="min-vh-100 bg-light">
    <!-- Header -->
    <div class="bg-white shadow-sm">
        <div class="container py-4">
            <div class="d-flex align-items-center justify-content-between">
                <div class="d-flex align-items-center">
                    <a href="{{ route('patient.dashboard') }}" class="text-muted me-3 text-decoration-none">
                        <svg width="24" height="24" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                        </svg>
                    </a>
                    <div>
                        <h1 class="fs-3 fw-bold text-dark mb-1">{{ __('customers.favorite_places') }}</h1>
                        <p class="small text-muted mb-0">{{ __('customers.places_you_added_to_favorites') }}</p>
                    </div>
                </div>
                <a href="{{ route('patient.search') }}" class="btn btn-primary d-flex align-items-center">
                    <svg class="me-2" width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                    </svg>
                    {{ __('ابحث عن أماكن') }}
                </a>
            </div>
        </div>
    </div>

    <div class="container py-4">
        <!-- Favorites Count -->
        <div class="row g-4 mb-4">
            <div class="col-lg-3">
                <div class="card">
                    <div class="card-body text-center">
                        <h3 class="fs-2 fw-bold text-danger mb-1" id="favoritesCount">{{ $favorites->total() ?? 0 }}</h3>
                        <p class="small text-muted mb-0">{{ __('مكان مفضل') }}</p>
                    </div>
                </div>
            </div>
            <div class="col-lg-9">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title fs-6 fw-semibold mb-3">{{ __('نصائح حول المفضلة') }}</h5>
                        <ul class="list-unstyled mb-0">
                            <li class="d-flex align-items-center mb-2">
                                <svg class="text-success me-2 flex-shrink-0" width="16" height="16" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                </svg>
                                {{ __('customers.quick_access_places') }}
                            </li>
                            <li class="d-flex align-items-center mb-2">
                                <svg class="text-success me-2 flex-shrink-0" width="16" height="16" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                </svg>
                                {{ __('customers.track_queues_favorites') }}
                            </li>
                            <li class="d-flex align-items-center mb-0">
                                <svg class="text-success me-2 flex-shrink-0" width="16" height="16" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                </svg>
                                {{ __('customers.special_notifications_favorites') }}
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <!-- Favorites List -->
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h3 class="fs-5 fw-semibold mb-0">{{ __('قائمة المفضلة') }}</h3>
                <div class="d-flex gap-2">
                    <select class="form-select form-select-sm" id="sortBy" style="width: auto;">
                        <option value="name">{{ __('الترتيب بالاسم') }}</option>
                        <option value="added">{{ __('تاريخ الإضافة') }}</option>
                        <option value="visits">{{ __('عدد الزيارات') }}</option>
                    </select>
                </div>
            </div>
            <div class="card-body">
                <div id="favoritesList">
                    @if($favorites->count() > 0)
                        @foreach($favorites as $favorite)
                        <div class="card mb-3">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-start mb-3">
                                    <div class="d-flex align-items-center">
                                        <div class="me-3">
                                            <div class="bg-primary bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center" style="width: 48px; height: 48px;">
                                                <svg class="text-primary" width="24" height="24" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                                                </svg>
                                            </div>
                                        </div>
                                        <div>
                                            <h5 class="fs-6 fw-semibold mb-1">{{ $favorite->name }}</h5>
                                            <p class="text-muted small mb-0">
                                                <svg class="me-1" width="12" height="12" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                                </svg>
                                                {{ $favorite->address ?: __('العنوان غير محدد') }}
                                            </p>
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-center gap-2">
                                        <button class="btn btn-sm btn-outline-danger" onclick="removeFavorite('{{ $favorite->uuid }}')">
                                            <svg width="14" height="14" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" clip-rule="evenodd"></path>
                                            </svg>
                                        </button>
                                        <a href="{{ route('patient.clinic.show', $favorite->uuid) }}" class="btn btn-sm btn-primary">
                                            {{ __('زيارة') }}
                                        </a>
                                    </div>
                                </div>
                                
                                <div class="row g-3">
                                    @if($favorite->phone)
                                    <div class="col-md-3">
<small class="text-muted">{{ __('customers.phone') }}</small>
                                        <p class="mb-0 small">{{ $favorite->phone }}</p>
                                    </div>
                                    @endif
                                    @if($favorite->email)
                                    <div class="col-md-3">
<small class="text-muted">{{ __('ui.email') }}</small>
                                        <p class="mb-0 small">{{ $favorite->email }}</p>
                                    </div>
                                    @endif
                                    <div class="col-md-3">
<small class="text-muted">{{ __('ui.services_count') }}</small>
                                        <p class="mb-0 small">{{ $favorite->visitTypes->count() }} {{ __('customers.visit_type') }}</p>
                                    </div>
                                    <div class="col-md-3">
<small class="text-muted">{{ __('ui.queue_status') }}</small>
                                        <span class="badge bg-success small">{{ __('متاح') }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
                        
                        <!-- Pagination -->
                        @if($favorites->hasPages())
                        <div class="mt-4">
                            {{ $favorites->links() }}
                        </div>
                        @endif
                    @else
                        <!-- Empty state -->
                        <div class="text-center py-5">
                            <svg class="text-muted mb-3" width="64" height="64" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"></path>
                            </svg>
<h3 class="fs-5 fw-semibold text-muted mb-2">{{ __('ui.no_favorite_places') }}</h3>
                            <p class="text-muted mb-4">{{ __('ui.add_places_to_favorites_hint') }}</p>
                            <a href="{{ route('patient.search') }}" class="btn btn-primary">
                                <svg class="me-2" width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                                </svg>
{{ __('ui.find_places') }}
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Sample Favorite Entry (hidden by default, for demo purposes) -->
        <div class="d-none" id="sampleFavorite">
            <div class="card mb-3">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start mb-3">
                        <div class="d-flex align-items-center">
                            <div class="me-3">
                                <div class="bg-primary bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center" style="width: 48px; height: 48px;">
                                    <svg class="text-primary" width="24" height="24" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                                    </svg>
                                </div>
                            </div>
                            <div>
                                <h5 class="fs-6 fw-semibold mb-1">{{ __('مركز الأسنان المتطور') }}</h5>
                                <p class="text-muted small mb-1">{{ __('د. أحمد محمد - أخصائي أسنان') }}</p>
                                <p class="text-muted small mb-0">
                                    <svg class="me-1" width="12" height="12" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                    </svg>
                                    {{ __('الرياض - حي النخيل') }}
                                </p>
                            </div>
                        </div>
                        <div class="d-flex align-items-center gap-2">
                            <button class="btn btn-sm btn-outline-danger" onclick="removeFavorite('sample')">
                                <svg width="14" height="14" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" clip-rule="evenodd"></path>
                                </svg>
                            </button>
<a href="#" class="btn btn-sm btn-primary">
                                {{ __('ui.visit') }}
                            </a>
                        </div>
                    </div>
                    
                    <div class="row g-3">
                        <div class="col-md-4">
                            <small class="text-muted">{{ __('آخر زيارة') }}</small>
                            <p class="mb-0 small">{{ __('15 مارس 2024') }}</p>
                        </div>
                        <div class="col-md-4">
                            <small class="text-muted">{{ __('عدد الزيارات') }}</small>
                            <p class="mb-0 small">{{ __('5 زيارات') }}</p>
                        </div>
                        <div class="col-md-4">
                            <small class="text-muted">{{ __('حالة الطابور') }}</small>
                            <span class="badge bg-success small">{{ __('متاح') }}</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
function removeFavorite(clinicId) {
    if (confirm('{{ __("هل أنت متأكد من إزالة هذا المكان من المفضلة؟") }}')) {
        // In real implementation, this would make an AJAX call to remove the favorite
        // For demo purposes, we'll just show a success message
        alert('{{ __("تم إزالة المكان من قائمة المفضلة") }}');
        
        // Refresh the favorites list
        loadFavorites();
    }
}

function loadFavorites() {
    document.getElementById('favoritesList').innerHTML = `
        <div class="text-center py-3">
            <div class="spinner-border text-primary" role="status">
                <span class="visually-hidden">{{ __('جاري التحميل...') }}</span>
            </div>
        </div>
    `;
    
    // Simulate loading
    setTimeout(() => {
                document.getElementById('favoritesList').innerHTML = `
            <div class=\"text-center py-5\">\r
                <svg class=\"text-muted mb-3\" width=\"64\" height=\"64\" fill=\"none\" stroke=\"currentColor\" viewBox=\"0 0 24 24\">\r
                    <path stroke-linecap=\"round\" stroke-linejoin=\"round\" stroke-width=\"2\" d=\"M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z\"></path>\r
                </svg>\r
                <h3 class=\"fs-5 fw-semibold text-muted mb-2\">{{ __('لا توجد أماكن مفضلة بعد') }}</h3>\r
                <p class=\"text-muted mb-4\">{{ __('أضف الأماكن التي تزورها بانتظام لقائمة المفضلة للوصول السريع') }}</p>\r
                <a href=\"{{ route('patient.search') }}\" class=\"btn btn-primary\">\r
                    <svg class=\"me-2\" width=\"16\" height=\"16\" fill=\"none\" stroke=\"currentColor\" viewBox=\"0 0 24 24\">\r
                        <path stroke-linecap=\"round\" stroke-linejoin=\"round\" stroke-width=\"2\" d=\"M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z\"></path>\r
                    </svg>\r
                    {{ __('ابحث عن أماكن') }}\r
                </a>\r
            </div>\r
        `;
        document.getElementById('favoritesCount').textContent = '0';
    }, 1000);
}

// Sort functionality
document.getElementById('sortBy').addEventListener('change', function() {
    loadFavorites(); // Reload with new sort order
});

// Load favorites on page load
document.addEventListener('DOMContentLoaded', function() {
    // Initial load is handled by the HTML content
});
</script>
@endpush
@endsection