@extends('layouts.patient')

@section('title', __('لوحة التحكم'))

@section('content')
<div class="min-vh-100 fade-in">


    <div class="container-fluid py-5">
        <!-- Current Queues with Enhanced Design -->
        @if($currentQueues->count() > 0)
        <div class="mb-6">
            <div class="d-flex align-items-center justify-content-between mb-4">
                <div class="d-flex align-items-center">
                    <div class="bg-primary rounded-circle p-3 me-3">
                        <i class="fas fa-clock text-white fa-lg"></i>
                    </div>
                    <div>
                        <h2 class="h3 fw-bold text-dark mb-1">{{ __('dashboard.current_queues') }}</h2>
                        <p class="text-muted mb-0">{{ __('queue.queue_updated') }}</p>
                    </div>
                </div>
                <div class="d-flex align-items-center gap-3">
                    <button onclick="refreshQueueList()" class="btn btn-outline-primary btn-sm" title="{{ __('تحديث') }}">
                        <i class="fas fa-sync-alt me-1"></i>
                        {{ __('تحديث') }}
                    </button>
                    <span class="badge bg-success rounded-pill px-3 py-2">
                        <i class="fas fa-users me-1"></i>
                        {{ $currentQueues->count() }} {{ __('طابور نشط') }}
                    </span>
                </div>
            </div>
            <div class="row g-4">
                @foreach($currentQueues as $queue)
                <div class="col-md-6 col-xl-4">
                    <div class="patient-card" data-tenant-uuid="{{ $queue->tenant->uuid }}">
                        <div class="card-body position-relative">
                            <!-- Status Indicator -->
                            <div class="position-absolute top-0 end-0 m-3">
                                @if(isset($queue->queue_type) && $queue->queue_type === 'walk-in')
                                    <div class="queue-position">
                                        {{ $queue->position ?? '?' }}
                                    </div>
                                @else
                                    <div class="bg-info text-white rounded-circle d-flex align-items-center justify-content-center"
                                         style="width: 80px; height: 80px; font-size: 0.8rem; font-weight: bold;">
                                        {{ __('موعد') }}
                                    </div>
                                @endif
                            </div>

                            <div class="mb-4">
                                <div class="d-flex align-items-start mb-3">
                                    <div class="flex-grow-1">
                                        <h5 class="fw-bold text-dark mb-2">{{ $queue->tenant->name }}</h5>
                                        <p class="text-muted small mb-2">
                                            <i class="fas fa-map-marker-alt me-1"></i>
                                            {{ $queue->tenant->address }}
                                        </p>
                                        <div class="d-flex align-items-center">
                                            <i class="fas fa-concierge-bell text-primary me-2"></i>
                                            <span class="small text-muted">{{ $queue->visitType->name ?? __('زيارة عامة') }}</span>
                                            @if(isset($queue->queue_type))
                                                <span class="badge ms-2
                                                    @if($queue->queue_type === 'walk-in') bg-success
                                                    @else bg-info @endif">
                                                    @if($queue->queue_type === 'walk-in')
                                                        {{ __('زائر عادي') }}
                                                    @else
                                                        {{ __('موعد') }}
                                                    @endif
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Queue Information Grid -->
                            <div class="row g-3 mb-4">
                                <div class="col-12">
                                    <div class="d-flex align-items-center justify-content-between p-3 bg-light rounded-3">
                                        <div class="d-flex align-items-center">
                                            <i class="fas fa-info-circle text-info me-2"></i>
                                            <span class="small fw-medium">{{ __('ui.status') }}</span>
                                        </div>
                                        <span class="
                                            @if($queue->status == 'waiting') status-waiting
                                            @elseif($queue->status == 'serving') status-serving
                                            @else status-completed @endif">
                                            {{ __($queue->status) }}
                                        </span>
                                    </div>
                                </div>

                                @if(isset($queue->queue_type) && $queue->queue_type === 'walk-in' && $queue->position)
                                <div class="col-6">
                                    <div class="text-center p-3 bg-primary bg-opacity-10 rounded-3">
                                        <div class="fw-bold text-primary h4 mb-1">#{{ $queue->position }}</div>
                                    <div class="small text-muted">{{ __('queue.your_position') }}</div>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="text-center p-3 bg-success bg-opacity-10 rounded-3">
                                        <div class="fw-bold text-success h4 mb-1">{{ $queue->total_walkins_waiting ?? 0 }}</div>
                                        <div class="small text-muted">{{ __('statistics.total_customers') }}</div>
                                    </div>
                                </div>
                                @elseif(isset($queue->queue_type) && $queue->queue_type === 'appointment' && $queue->appointment_time)
                                <div class="col-12">
                                    <div class="text-center p-3 bg-info bg-opacity-10 rounded-3">
                                        <div class="fw-bold text-info h5 mb-1">
                                            {{ $queue->appointment_time->format('d/m/Y') }}
                                        </div>
                                        <div class="fw-bold text-info h4 mb-1">
                                            {{ $queue->appointment_time->format('H:i') }}
                                        </div>
                                        <div class="small text-muted">
                                            @if($queue->is_appointment_due ?? false)
                                                <span class="text-success">{{ __('queue.with_appointment') }}</span>
                                            @else
                                                {{ __('queue.with_appointment') }}
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                @endif


                                <div class="col-12">
                                    <div class="d-flex align-items-center justify-content-between p-2 rounded-3" style="background-color: rgba(0, 123, 255, 0.05);">
                                        <div class="d-flex align-items-center">
                                            <i class="fas fa-clock text-secondary me-2"></i>
                                            <span class="small text-muted">{{ __('queue.arrival_time') }}</span>
                                        </div>
                                        <span class="small fw-medium text-dark">{{ $queue->arrival_time->format('H:i') }}</span>
                                    </div>
                                </div>
                            </div>

                            <!-- Action Buttons -->
                            <div class="d-flex gap-3">
                                <a href="{{ route('patient.clinic.show', $queue->tenant->uuid) }}"
                                   class="btn btn-patient-secondary flex-grow-1 d-flex align-items-center justify-content-center">
                                    <i class="fas fa-eye me-2"></i>
                                    {{ __('ui.view_details') }}
                                </a>
                                <button onclick="leaveQueue('{{ $queue->tenant->uuid }}')"
                                        class="btn btn-patient-danger px-4"
                                        title="{{ __('queue.removed_from_queue') }}">
                                    <i class="fas fa-sign-out-alt"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
        @endif

        <!-- Favorite Clinics -->
        @if($favoriteTenants->count() > 0)
        <div class="mt-5">
            <div class="d-flex align-items-center justify-content-between mb-4">
                <h2 class="h4 fw-semibold text-dark mb-0">
                    <i class="fas fa-heart text-danger me-2"></i>
                    {{ __('dashboard.favorite_places') }}
                </h2>
                <a href="{{ route('patient.favorites') }}" class="btn btn-sm btn-outline-primary">{{ __('عرض الكل') }}</a>
            </div>
            <div class="row g-4">
                @foreach($favoriteTenants->take(3) as $tenant)
                <div class="col-md-6 col-lg-4">
                    <div class="patient-card h-100">
                        <div class="card-body">
                            <div class="d-flex align-items-start justify-content-between mb-3">
                                <div class="flex-grow-1">
                                    <h5 class="fw-semibold text-dark mb-1">{{ $tenant->name }}</h5>
                                    <p class="text-muted small mb-0">{{ $tenant->address }}</p>
                                </div>
                                <button class="favorite-btn is-favorite" title="{{ __('إزالة من المفضلة') }}">
                                    <i class="fas fa-heart"></i>
                                </button>
                            </div>

                            <a href="{{ route('patient.clinic.show', $tenant->uuid) }}"
                               class="btn btn-patient-primary w-100">
                                <i class="fas fa-eye me-2"></i>
                                {{ __('عرض التفاصيل') }}
                            </a>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
        @endif
    </div>
</div>

<style>
/* Refresh button styles */
.btn-outline-primary:hover .fa-sync-alt {
    transform: rotate(180deg);
    transition: transform 0.3s ease;
}

.btn.btn-success {
    transition: all 0.3s ease;
}

.fa-spinner {
    animation: spin 1s linear infinite;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

/* Enhanced button animations */
.btn {
    transition: all 0.2s ease;
}

.btn:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(0, 123, 255, 0.2);
}
</style>

<script>
// Enhanced queue management with loading states and animations
function leaveQueue(tenantUuid) {
    // Create modern confirmation modal
    if (showConfirmModal('{{ __("تأكيد المغادرة") }}', '{{ __("هل أنت متأكد من مغادرة هذا الطابور؟ لن تتمكن من استرداد مكانك.") }}')) {
        const button = event.target.closest('button');
        const card = button.closest('.patient-card');

        // Show loading state
        showLoadingState(button);
        card.style.opacity = '0.6';

        fetch(`/patient/clinic/${tenantUuid}/leave`, {
            method: 'DELETE',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            }
        })
        .then(response => response.json())
        .then(data => {
            hideLoadingState(button);

            if (data.success) {
                // Animate card removal
                card.style.transform = 'translateX(-100%)';
                card.style.opacity = '0';

                setTimeout(() => {
                    showSuccessToast('{{ __("تم مغادرة الطابور بنجاح") }}');
                    location.reload();
                }, 300);
            } else {
                card.style.opacity = '1';
                showErrorToast(data.message || '{{ __("حدث خطأ، يرجى المحاولة مرة أخرى") }}');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            hideLoadingState(button);
            card.style.opacity = '1';
            showErrorToast('{{ __("حدث خطأ، يرجى المحاولة مرة أخرى") }}');
        });
    }
}

// Enhanced loading states
function showLoadingState(element) {
    const originalHtml = element.innerHTML;
    element.dataset.originalHtml = originalHtml;
    element.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';
    element.disabled = true;
}

function hideLoadingState(element) {
    element.innerHTML = element.dataset.originalHtml;
    element.disabled = false;
}

// Modern confirmation modal
function showConfirmModal(title, message) {
    return confirm(`${title}\n\n${message}`);
}

// Toast notifications
function showSuccessToast(message) {
    showToast(message, 'success');
}

function showErrorToast(message) {
    showToast(message, 'error');
}

function showToast(message, type = 'info') {
    const toast = document.createElement('div');
    toast.className = `alert alert-${type === 'success' ? 'success' : 'danger'} alert-dismissible position-fixed top-0 end-0 m-3`;
    toast.style.zIndex = '9999';
    toast.style.minWidth = '300px';
    toast.innerHTML = `
        <i class="fas fa-${type === 'success' ? 'check-circle' : 'exclamation-circle'} me-2"></i>
        ${message}
        <button type="button" class="btn-close" onclick="this.parentElement.remove()"></button>
    `;

    document.body.appendChild(toast);

    // Auto remove after 5 seconds
    setTimeout(() => {
        if (toast.parentElement) {
            toast.style.opacity = '0';
            toast.style.transform = 'translateX(100%)';
            setTimeout(() => toast.remove(), 300);
        }
    }, 5000);
}

// Queue management functions
function refreshQueueList() {
    const refreshBtn = event.target.closest('button');
    const originalHtml = refreshBtn.innerHTML;

    // Show loading state
    refreshBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-1"></i>{{ __("جارٍ التحديث...") }}';
    refreshBtn.disabled = true;

    // Show success animation
    setTimeout(() => {
        refreshBtn.innerHTML = '<i class="fas fa-check me-1"></i>{{ __("تم التحديث") }}';
        refreshBtn.classList.add('btn-success');
        refreshBtn.classList.remove('btn-outline-primary');

        setTimeout(() => {
            // Reload the page to get fresh data
            location.reload();
        }, 800);
    }, 1000);
}

// Simple function for any remaining queue status calls
function updateQueueStatus(tenantUuid, cardElement) {
    // This function is now simplified - queue updates happen via manual refresh
    console.log('Queue status update requested for:', tenantUuid);
}

// Initialize page animations and interactions
document.addEventListener('DOMContentLoaded', () => {

    // Add stagger animation to cards
    const cards = document.querySelectorAll('.patient-card, .info-card');
    cards.forEach((card, index) => {
        card.style.animationDelay = `${index * 0.1}s`;
        card.classList.add('fade-in');
    });

    // Add hover effects to quick action items
    const quickActions = document.querySelectorAll('.quick-action-item');
    quickActions.forEach(action => {
        action.addEventListener('mouseenter', function() {
            this.style.transform = 'translateY(-5px)';
            this.style.boxShadow = '0 12px 30px rgba(0, 123, 255, 0.15)';
        });

        action.addEventListener('mouseleave', function() {
            this.style.transform = 'translateY(0)';
            this.style.boxShadow = 'none';
        });
    });

    // Smooth scroll for internal links
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            const target = document.querySelector(this.getAttribute('href'));
            if (target) {
                target.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });

    // Add ripple effect to buttons
    document.querySelectorAll('.btn').forEach(button => {
        button.addEventListener('click', createRipple);
    });
});

// Ripple effect for buttons
function createRipple(event) {
    const button = event.currentTarget;
    const circle = document.createElement('span');
    const diameter = Math.max(button.clientWidth, button.clientHeight);
    const radius = diameter / 2;

    const rect = button.getBoundingClientRect();
    circle.style.width = circle.style.height = `${diameter}px`;
    circle.style.left = `${event.clientX - rect.left - radius}px`;
    circle.style.top = `${event.clientY - rect.top - radius}px`;
    circle.classList.add('ripple');

    const ripple = button.getElementsByClassName('ripple')[0];
    if (ripple) {
        ripple.remove();
    }

    button.appendChild(circle);
}
</script>
@endsection
