<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pairing Session Expired</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 1rem;
        }
        
        .mobile-container {
            max-width: 400px;
            margin: 2rem auto;
        }
        
        .expired-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            padding: 2rem;
            text-align: center;
        }
        
        .expired-icon {
            width: 80px;
            height: 80px;
            background: #ffc107;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1.5rem;
        }
        
        .expired-title {
            font-size: 1.5rem;
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 1rem;
        }
        
        .expired-message {
            color: #718096;
            margin-bottom: 2rem;
            line-height: 1.6;
        }
        
        .btn-retry {
            background: linear-gradient(135deg, #667eea, #764ba2);
            border: none;
            border-radius: 12px;
            padding: 0.8rem 2rem;
            font-size: 1rem;
            font-weight: 600;
            color: white;
            transition: all 0.3s;
        }
        
        .btn-retry:hover {
            background: linear-gradient(135deg, #5a6fd8, #6a4190);
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(102, 126, 234, 0.3);
        }
        
        .help-text {
            background: #f7fafc;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 1rem;
            margin-top: 1.5rem;
            font-size: 0.9rem;
            color: #4a5568;
        }
    </style>
</head>
<body>
    <div class="mobile-container">
        <div class="expired-card">
            <div class="expired-icon">
                <i class="fas fa-clock text-white" style="font-size: 2rem;"></i>
            </div>
            
            <h2 class="expired-title">Pairing Session Expired</h2>
            
            <p class="expired-message">
                This pairing session has expired for security reasons. 
                Please generate a new QR code on the display to continue.
            </p>
            
            <button class="btn btn-retry" onclick="window.close()">
                <i class="fas fa-times me-2"></i>
                Close
            </button>
            
            <div class="help-text">
                <div class="d-flex align-items-start">
                    <i class="fas fa-info-circle me-2 text-primary mt-1"></i>
                    <div>
                        <div class="fw-semibold">What to do next:</div>
                        <div>Go back to the TV screen and refresh the pairing page to generate a new QR code.</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>