<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Pair Display - {{ $display->name }}</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 1rem;
        }
        
        .mobile-container {
            max-width: 400px;
            margin: 2rem auto;
        }
        
        .auth-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            padding: 2rem;
            text-align: center;
        }
        
        .auth-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 4px;
            background: linear-gradient(90deg, #667eea, #764ba2);
            border-radius: 20px 20px 0 0;
        }
        
        .display-icon {
            width: 60px;
            height: 60px;
            background: linear-gradient(135deg, #667eea, #764ba2);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1.5rem;
        }
        
        .display-name {
            font-size: 1.5rem;
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 0.5rem;
        }
        
        .pairing-subtitle {
            color: #718096;
            margin-bottom: 2rem;
            font-size: 0.95rem;
        }
        
        .form-floating {
            margin-bottom: 1rem;
        }
        
        .form-control {
            border-radius: 12px;
            border: 2px solid #e2e8f0;
            font-size: 1rem;
            transition: all 0.3s;
        }
        
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
        }
        
        .btn-pair {
            background: linear-gradient(135deg, #667eea, #764ba2);
            border: none;
            border-radius: 12px;
            padding: 0.8rem;
            font-size: 1.1rem;
            font-weight: 600;
            width: 100%;
            color: white;
            transition: all 0.3s;
        }
        
        .btn-pair:hover {
            background: linear-gradient(135deg, #5a6fd8, #6a4190);
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(102, 126, 234, 0.3);
        }
        
        .btn-pair:disabled {
            opacity: 0.7;
            transform: none;
            box-shadow: none;
        }
        
        .security-notice {
            background: #f7fafc;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 1rem;
            margin-top: 1.5rem;
            font-size: 0.9rem;
            color: #4a5568;
        }
        
        .success-message {
            display: none;
            color: #28a745;
            margin-top: 1rem;
        }
        
        .error-message {
            display: none;
            color: #dc3545;
            margin-top: 1rem;
        }
        
        .loading-spinner {
            display: none;
            margin-top: 1rem;
        }
        
        @media (max-width: 480px) {
            .mobile-container {
                margin: 1rem auto;
            }
            
            .auth-card {
                padding: 1.5rem;
            }
        }
    </style>
</head>
<body>
    <div class="mobile-container">
        <div class="auth-card position-relative">
            <div class="display-icon">
                <i class="fas fa-tv text-white" style="font-size: 1.5rem;"></i>
            </div>
            
            <h2 class="display-name">{{ $display->name }}</h2>
            <p class="pairing-subtitle">
                Enter your credentials to pair this display with your account
            </p>
            
            <form id="authForm">
                @csrf
                <div class="form-floating">
                    <input type="email" class="form-control" id="email" name="email" placeholder="Email Address" required>
                    <label for="email">
                        <i class="fas fa-envelope me-2"></i>Email Address
                    </label>
                </div>
                
                <div class="form-floating">
                    <input type="password" class="form-control" id="password" name="password" placeholder="Password" required>
                    <label for="password">
                        <i class="fas fa-lock me-2"></i>Password
                    </label>
                </div>
                
                <button type="submit" class="btn btn-pair" id="pairButton">
                    <i class="fas fa-link me-2"></i>
                    Pair Display
                </button>
            </form>
            
            <div class="loading-spinner" id="loadingSpinner">
                <div class="spinner-border text-primary" role="status">
                    <span class="visually-hidden">Pairing...</span>
                </div>
                <p class="mt-2 text-muted">Pairing display...</p>
            </div>
            
            <div class="success-message" id="successMessage">
                <div class="d-flex align-items-center justify-content-center mb-2">
                    <i class="fas fa-check-circle me-2" style="font-size: 1.5rem;"></i>
                    <span class="fw-bold">Display Paired Successfully!</span>
                </div>
                <p class="mb-0">The TV will now show your waiting room display.</p>
            </div>
            
            <div class="error-message" id="errorMessage">
                <div class="d-flex align-items-center justify-content-center mb-2">
                    <i class="fas fa-exclamation-triangle me-2" style="font-size: 1.5rem;"></i>
                    <span class="fw-bold">Pairing Failed</span>
                </div>
                <p class="mb-0" id="errorText">Please check your credentials and try again.</p>
            </div>
            
            <div class="security-notice">
                <div class="d-flex align-items-start">
                    <i class="fas fa-shield-alt me-2 text-primary mt-1"></i>
                    <div>
                        <div class="fw-semibold">Secure Pairing</div>
                        <div>Your credentials are only used to authenticate this display and are not stored on the device.</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const form = document.getElementById('authForm');
            const pairButton = document.getElementById('pairButton');
            const loadingSpinner = document.getElementById('loadingSpinner');
            const successMessage = document.getElementById('successMessage');
            const errorMessage = document.getElementById('errorMessage');
            const errorText = document.getElementById('errorText');
            
            form.addEventListener('submit', async function(e) {
                e.preventDefault();
                
                // Show loading state
                showLoading();
                
                try {
                    const formData = new FormData(form);
                    const response = await fetch('{{ route('display.mobile.auth.process', [$deviceToken, $sessionId]) }}', {
                        method: 'POST',
                        body: formData,
                        headers: {
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                            'X-Requested-With': 'XMLHttpRequest',
                            'Accept': 'application/json'
                        }
                    });
                    
                    const data = await response.json();
                    
                    if (data.success) {
                        showSuccess();
                        setTimeout(() => {
                            window.close(); // Close mobile browser
                        }, 3000);
                    } else {
                        showError(data.message || 'Authentication failed. Please try again.');
                    }
                    
                } catch (error) {
                    console.error('Pairing error:', error);
                    showError('Network error. Please check your connection and try again.');
                }
            });
            
            function showLoading() {
                form.style.display = 'none';
                loadingSpinner.style.display = 'block';
                successMessage.style.display = 'none';
                errorMessage.style.display = 'none';
            }
            
            function showSuccess() {
                form.style.display = 'none';
                loadingSpinner.style.display = 'none';
                successMessage.style.display = 'block';
                errorMessage.style.display = 'none';
            }
            
            function showError(message) {
                form.style.display = 'block';
                loadingSpinner.style.display = 'none';
                successMessage.style.display = 'none';
                errorMessage.style.display = 'block';
                errorText.textContent = message;
                
                // Clear password field on error
                document.getElementById('password').value = '';
            }
        });
    </script>
</body>
</html>