<!DOCTYPE html>
<html lang="ar" dir="rtl">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>{{ __('display.waiting_room_display') }}</title>
        <link rel="stylesheet" href="styles.css">
        <link rel="stylesheet" href="animations.css">
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <meta name="tenant-id" content="{{ $tenantId }}">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Arabic:wght@300;400;500;600;700&display=swap" rel="stylesheet">
        <meta name="description" content="{{ __('display.system_description') }}">

    <style>

      /* Advanced Animations and Micro-interactions */

/* Entrance Animations */
@keyframes slideInFromRight {
  0% {
    transform: translateX(100px);
    opacity: 0;
  }
  100% {
    transform: translateX(0);
    opacity: 1;
  }
}

@keyframes slideInFromLeft {
  0% {
    transform: translateX(-100px);
    opacity: 0;
  }
  100% {
    transform: translateX(0);
    opacity: 1;
  }
}

@keyframes fadeInUp {
  0% {
    transform: translateY(30px);
    opacity: 0;
  }
  100% {
    transform: translateY(0);
    opacity: 1;
  }
}

@keyframes scaleIn {
  0% {
    transform: scale(0.8);
    opacity: 0;
  }
  100% {
    transform: scale(1);
    opacity: 1;
  }
}

/* Apply entrance animations */
.left-column {
  animation: slideInFromLeft 0.8s ease-out;
}

.right-column {
  animation: slideInFromRight 0.8s ease-out;
}

.section-title {
  animation: fadeInUp 0.6s ease-out;
  animation-fill-mode: both;
}

.section-title:nth-of-type(1) { animation-delay: 0.1s; }
.section-title:nth-of-type(2) { animation-delay: 0.3s; }

#current {
  animation: scaleIn 0.8s ease-out;
  animation-delay: 0.4s;
  animation-fill-mode: both;
}

.list-container {
  animation: fadeInUp 0.6s ease-out;
  animation-fill-mode: both;
}

.list-container:nth-child(1) { animation-delay: 0.5s; }
.list-container:nth-child(2) { animation-delay: 0.6s; }

/* Advanced Hover Effects */
.list-box {
  position: relative;
  overflow: hidden;
}

.list-box::after {
  content: '';
  position: absolute;
  top: 0;
  left: -100%;
  width: 100%;
  height: 100%;
  background: linear-gradient(90deg, transparent, rgba(37, 99, 235, 0.1), transparent);
  transition: left 0.5s ease;
}

.list-box:hover::after {
  left: 100%;
}

/* Floating Animation for Clock */
#clock {
  animation: float 6s ease-in-out infinite;
}

@keyframes float {
  0%, 100% {
    transform: translateY(0px);
  }
  50% {
    transform: translateY(-10px);
  }
}

/* Pulsing Effect for Current Customer */
#current {
  position: relative;
}

#current::after {
  content: '';
  position: absolute;
  top: 50%;
  left: 50%;
  width: 20px;
  height: 20px;
  background: rgba(255, 255, 255, 0.3);
  border-radius: 50%;
  transform: translate(-50%, -50%);
  animation: ripple 2s infinite;
}

@keyframes ripple {
  0% {
    width: 20px;
    height: 20px;
    opacity: 1;
  }
  100% {
    width: 200px;
    height: 200px;
    opacity: 0;
  }
}

/* Staggered List Item Animations */
.list-box {
  animation: slideInFromBottom 0.5s ease-out;
  animation-fill-mode: both;
}

@keyframes slideInFromBottom {
  0% {
    transform: translateY(20px);
    opacity: 0;
  }
  100% {
    transform: translateY(0);
    opacity: 1;
  }
}

/* Dynamic Number Animations */
.customer-number {
  animation: numberPop 0.3s ease-out;
  position: relative;
  overflow: hidden;
}

@keyframes numberPop {
  0% {
    transform: scale(0);
  }
  50% {
    transform: scale(1.2);
  }
  100% {
    transform: scale(1);
  }
}

.customer-number::before {
  content: '';
  position: absolute;
  top: 0;
  left: -100%;
  width: 100%;
  height: 100%;
  background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.4), transparent);
  animation: numberShine 2s infinite;
}

@keyframes numberShine {
  0% { left: -100%; }
  100% { left: 100%; }
}

/* Advanced Section Title Effects */
.section-title {
  position: relative;
  overflow: hidden;
}

.section-title::before {
  content: '';
  position: absolute;
  top: 0;
  left: -100%;
  width: 100%;
  height: 100%;
  background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
  animation: titleSweep 3s infinite;
}

@keyframes titleSweep {
  0% { left: -100%; }
  100% { left: 100%; }
}

/* Interactive Click Effects */
.clickable {
  transition: all 0.1s ease;
}

.clickable:active {
  transform: scale(0.95);
}

/* Status Indicator Advanced Animation */
.status-indicator {
  animation: statusSlideIn 0.5s ease-out;
}

@keyframes statusSlideIn {
  0% {
    transform: translateX(-100px);
    opacity: 0;
  }
  100% {
    transform: translateX(0);
    opacity: 1;
  }
}

.status-dot {
  position: relative;
}

.status-dot::after {
  content: '';
  position: absolute;
  top: 50%;
  left: 50%;
  width: 100%;
  height: 100%;
  border-radius: 50%;
  background: inherit;
  transform: translate(-50%, -50%);
  animation: dotPulse 2s infinite;
}

@keyframes dotPulse {
  0% {
    transform: translate(-50%, -50%) scale(1);
    opacity: 1;
  }
  100% {
    transform: translate(-50%, -50%) scale(2);
    opacity: 0;
  }
}

/* Loading Spinner Enhancement */
.loading-spinner {
  position: relative;
}

.loading-spinner::after {
  content: '';
  position: absolute;
  top: 50%;
  left: 50%;
  width: 30px;
  height: 30px;
  border: 2px solid rgba(255, 255, 255, 0.5);
  border-radius: 50%;
  transform: translate(-50%, -50%);
  animation: innerSpin 1.5s linear infinite reverse;
}

@keyframes innerSpin {
  0% { transform: translate(-50%, -50%) rotate(0deg); }
  100% { transform: translate(-50%, -50%) rotate(360deg); }
}

/* Smooth Transitions for Dynamic Content */
.fade-transition {
  transition: opacity 0.3s ease, transform 0.3s ease;
}

.fade-out {
  opacity: 0;
  transform: translateY(-10px);
}

.fade-in {
  opacity: 1;
  transform: translateY(0);
}

/* Advanced Gradient Animations */
.gradient-shift {
  background-size: 200% 200%;
  animation: gradientShift 4s ease infinite;
}

@keyframes gradientShift {
  0% { background-position: 0% 50%; }
  50% { background-position: 100% 50%; }
  100% { background-position: 0% 50%; }
}

/* Apply gradient shift to current customer */
#current {
  background-size: 200% 200%;
  animation: gradientShift 4s ease infinite, scaleIn 0.8s ease-out;
  animation-delay: 0s, 0.4s;
  animation-fill-mode: infinite, both;
}

/* Particle Effect for Background */
.particle {
  position: absolute;
  width: 4px;
  height: 4px;
  background: rgba(255, 255, 255, 0.1);
  border-radius: 50%;
  animation: particleFloat 10s infinite linear;
}

@keyframes particleFloat {
  0% {
    transform: translateY(100vh) rotate(0deg);
    opacity: 0;
  }
  10% {
    opacity: 1;
  }
  90% {
    opacity: 1;
  }
  100% {
    transform: translateY(-100px) rotate(360deg);
    opacity: 0;
  }
}

/* Responsive Animation Adjustments */
@media (max-width: 768px) {
  .left-column,
  .right-column {
    animation-duration: 0.5s;
  }

  #clock {
    animation: none; /* Disable float on mobile for performance */
  }

  .list-box::after {
    display: none; /* Disable hover effects on mobile */
  }
}

/* Reduced Motion Support */
@media (prefers-reduced-motion: reduce) {
  * {
    animation-duration: 0.01ms !important;
    animation-iteration-count: 1 !important;
    transition-duration: 0.01ms !important;
  }

  #current::after,
  .status-dot::after,
  .particle {
    display: none;
  }
}

/* High Performance Mode */
@media (max-width: 480px) {
  .section-title::before,
  .list-box::after,
  .customer-number::before,
  #current::after {
    display: none;
  }
}

/* Modern Waiting Room Display Styles */

/* Import Google Fonts for Arabic support */
@import url('https://fonts.googleapis.com/css2?family=Noto+Sans+Arabic:wght@300;400;500;600;700&display=swap');

/* CSS Variables for consistent theming */
:root {
  --primary-color: #2563eb;
  --primary-dark: #1d4ed8;
  --secondary-color: #10b981;
  --accent-color: #f59e0b;
  --background-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
  --card-background: rgba(255, 255, 255, 0.95);
  --text-primary: #1f2937;
  --text-secondary: #6b7280;
  --shadow-light: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
  --shadow-medium: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
  --shadow-heavy: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
  --border-radius: 16px;
  --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
}

/* Reset and base styles */
* {
  margin: 0;
  padding: 0;
  box-sizing: border-box;
}

body {
  font-family: 'Noto Sans Arabic', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
  background: var(--background-gradient);
  min-height: 100vh;
  padding: 2rem;
  direction: rtl;
  overflow-x: hidden;
  position: relative;
}

/* Animated background elements */
body::before {
  content: '';
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background:
    radial-gradient(circle at 20% 80%, rgba(120, 119, 198, 0.3) 0%, transparent 50%),
    radial-gradient(circle at 80% 20%, rgba(255, 119, 198, 0.3) 0%, transparent 50%),
    radial-gradient(circle at 40% 40%, rgba(120, 219, 255, 0.3) 0%, transparent 50%);
  animation: backgroundFloat 20s ease-in-out infinite;
  z-index: -1;
}

@keyframes backgroundFloat {
  0%, 100% { transform: translateY(0px) rotate(0deg); }
  33% { transform: translateY(-20px) rotate(1deg); }
  66% { transform: translateY(10px) rotate(-1deg); }
}

/* Main container */
.container {
  margin: 0 auto;
  display: grid;
  grid-template-columns: 1fr 2fr;
  gap: 1rem;
  height: calc(100vh - 4rem);
}

/* Clock styling */
#clock {
  background: var(--card-background);
  backdrop-filter: blur(20px);
  border: 1px solid rgba(255, 255, 255, 0.2);
  border-radius: var(--border-radius);
  padding: 2rem;
  text-align: center;
  font-size: 4rem;
  font-weight: 700;
  color: var(--primary-color);
  box-shadow: var(--shadow-heavy);
  margin-bottom: 2rem;
  position: relative;
  overflow: hidden;
  transition: var(--transition);
}

#clock::before {
  content: '';
  position: absolute;
  top: 0;
  left: -100%;
  width: 100%;
  height: 100%;
  background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.4), transparent);
  animation: shimmer 3s infinite;
}

@keyframes shimmer {
  0% { left: -100%; }
  100% { left: 100%; }
}

#clock:hover {
  transform: translateY(-5px);
  box-shadow: var(--shadow-heavy), 0 0 30px rgba(37, 99, 235, 0.3);
}

/* Section titles */
.section-title {
  background: linear-gradient(135deg, var(--primary-color), var(--primary-dark));
  color: white;
  padding: 1.5rem 2rem;
  border-radius: var(--border-radius);
  font-size: 1.8rem;
  font-weight: 600;
  text-align: center;
  margin-bottom: 1.5rem;
  box-shadow: var(--shadow-medium);
  position: relative;
  overflow: hidden;
  transition: var(--transition);
}

.section-title::after {
  content: '';
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  height: 2px;
  background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.8), transparent);
  animation: titleGlow 2s ease-in-out infinite alternate;
}

@keyframes titleGlow {
  0% { opacity: 0.5; }
  100% { opacity: 1; }
}

/* Current customer display */
#current {
  background: linear-gradient(135deg, var(--secondary-color), #059669);
  color: white;
  padding: 3rem 2rem;
  border-radius: var(--border-radius);
  font-size: 2.5rem;
  font-weight: 700;
  text-align: center;
  box-shadow: var(--shadow-heavy);
  margin-bottom: 2rem;
  position: relative;
  overflow: hidden;
  transition: var(--transition);
  animation: pulse 2s ease-in-out infinite;
}

@keyframes pulse {
  0%, 100% { transform: scale(1); }
  50% { transform: scale(1.02); }
}

#current::before {
  content: '';
  position: absolute;
  top: -50%;
  left: -50%;
  width: 200%;
  height: 200%;
  background: radial-gradient(circle, rgba(255, 255, 255, 0.1) 0%, transparent 70%);
  animation: rotate 10s linear infinite;
}

@keyframes rotate {
  0% { transform: rotate(0deg); }
  100% { transform: rotate(360deg); }
}

/* List section container */
.list-section {
  display: grid;
  grid-template-columns: 1fr 1fr;
  gap: 1rem;
  height: 100%;
}

.list-section > div {
  background: var(--card-background);
  backdrop-filter: blur(20px);
  border: 1px solid rgba(255, 255, 255, 0.2);
  border-radius: var(--border-radius);
  padding: 2rem;
  box-shadow: var(--shadow-medium);
  display: flex;
  flex-direction: column;
  transition: var(--transition);
}

.list-section > div:hover {
  transform: translateY(-5px);
  box-shadow: var(--shadow-heavy);
}

/* List headers */
.list-section h4 {
  color: var(--primary-color);
  font-size: 1.5rem;
  font-weight: 600;
  margin-bottom: 1.5rem;
  padding-bottom: 1rem;
  border-bottom: 2px solid var(--primary-color);
  position: relative;
}

.list-section h4::after {
  content: '';
  position: absolute;
  bottom: -2px;
  left: 0;
  width: 50px;
  height: 2px;
  background: var(--accent-color);
  animation: expandLine 1s ease-out;
}

@keyframes expandLine {
  0% { width: 0; }
  100% { width: 50px; }
}

/* Lists */
ul {
  list-style: none;
  flex: 1;
  overflow-y: auto;
  scrollbar-width: thin;
  scrollbar-color: var(--primary-color) transparent;
}

ul::-webkit-scrollbar {
  width: 6px;
}

ul::-webkit-scrollbar-track {
  background: transparent;
}

ul::-webkit-scrollbar-thumb {
  background: var(--primary-color);
  border-radius: 3px;
}

/* List items */
.list-box {
  background: linear-gradient(135deg, #f8fafc, #e2e8f0);
  border: 1px solid rgba(37, 99, 235, 0.1);
  border-radius: 12px;
  padding: 1.5rem;
  margin-bottom: 1rem;
  font-size: 2.2rem;
  font-weight: 500;
  color: var(--text-primary);
  box-shadow: var(--shadow-light);
  transition: var(--transition);
  position: relative;
  overflow: hidden;
  cursor: pointer;
}

.list-box::before {
  content: '';
  position: absolute;
  top: 0;
  left: 0;
  width: 4px;
  height: 100%;
  background: var(--primary-color);
  transition: var(--transition);
}

.list-box:hover {
  transform: translateX(-5px);
  box-shadow: var(--shadow-medium);
  background: linear-gradient(135deg, #ffffff, #f1f5f9);
}

.list-box:hover::before {
  width: 8px;
  background: var(--accent-color);
}

.list-box:nth-child(even) {
  background: linear-gradient(135deg, #fefefe, #f8fafc);
}

.list-box:nth-child(odd):hover {
  background: linear-gradient(135deg, #ffffff, #f8fafc);
}

/* Left column layout */
.left-column {
  display: flex;
  flex-direction: column;
}

.right-column {
  display: flex;
  flex-direction: column;
}

/* Responsive design */
@media (max-width: 1200px) {
  .container {
    grid-template-columns: 1fr;
    gap: 1.5rem;
  }

  #clock {
    font-size: 3rem;
    padding: 1.5rem;
  }

  #current {
    font-size: 2rem;
    padding: 2rem 1.5rem;
  }
}

@media (max-width: 768px) {
  body {
    padding: 1rem;
  }

  .list-section {
    grid-template-columns: 1fr;
    gap: 1rem;
  }

  #clock {
    font-size: 2.5rem;
    padding: 1rem;
  }

  #current {
    font-size: 1.5rem;
    padding: 1.5rem 1rem;
  }

  .section-title {
    font-size: 1.4rem;
    padding: 1rem 1.5rem;
  }

  .list-box {
    padding: 1rem;
    font-size: 1rem;
  }
}

/* Loading animation */
.loading {
  opacity: 0.7;
  animation: loadingPulse 1.5s ease-in-out infinite;
}

@keyframes loadingPulse {
  0%, 100% { opacity: 0.7; }
  50% { opacity: 1; }
}

/* Success animation for updates */
.updated {
  animation: successFlash 0.5s ease-out;
}

@keyframes successFlash {
  0% { background-color: rgba(16, 185, 129, 0.2); }
  100% { background-color: transparent; }
}

/* Empty state styling */
.empty-state {
  text-align: center;
  color: var(--text-secondary);
  font-style: italic;
  padding: 2rem;
  opacity: 0.7;
}

/* Accessibility improvements */
@media (prefers-reduced-motion: reduce) {
  * {
    animation-duration: 0.01ms !important;
    animation-iteration-count: 1 !important;
    transition-duration: 0.01ms !important;
  }
}

/* High contrast mode */
@media (prefers-contrast: high) {
  :root {
    --card-background: rgba(255, 255, 255, 1);
    --text-primary: #000000;
    --text-secondary: #333333;
  }
}



/* Enhanced Current Customer Display */
.current-content {
  display: flex;
  flex-direction: column;
  align-items: center;
  gap: 0.5rem;
}

.current-label {
  font-size: 1.2rem;
  font-weight: 400;
  opacity: 0.9;
}

.current-name {
  font-size: 2.5rem;
  font-weight: 700;
  text-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
}

/* Enhanced List Titles */
.list-title {
  display: flex;
  align-items: center;
  gap: 0.5rem;
  position: relative;
}

.list-title .icon {
  font-size: 1.2em;
}

/* Count Badges */
.count-badge {
  background: var(--accent-color);
  color: white;
  font-size: 0.9rem;
  font-weight: 600;
  padding: 0.3rem 0.8rem;
  border-radius: 20px;
  margin-right: auto;
  box-shadow: var(--shadow-light);
  animation: countPulse 0.3s ease-out;
}

@keyframes countPulse {
  0% { transform: scale(1.2); }
  100% { transform: scale(1); }
}

/* Customer Info Styling */
.customer-info {
  display: flex;
  align-items: center;
  gap: 1rem;
  width: 100%;
}

.customer-number {
  background: var(--primary-color);
  color: white;
  font-weight: 600;
  font-size: 0.9rem;
  width: 2rem;
  height: 2rem;
  border-radius: 50%;
  display: flex;
  align-items: center;
  justify-content: center;
  flex-shrink: 0;
}

.customer-name {
  flex: 1;
  font-weight: 500;
}

/* Loading Overlay */
.loading-overlay {
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background: rgba(0, 0, 0, 0.5);
  backdrop-filter: blur(5px);
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  z-index: 1000;
  opacity: 0;
  animation: fadeIn 0.3s ease-out forwards;
}

@keyframes fadeIn {
  to { opacity: 1; }
}

.loading-spinner {
  width: 60px;
  height: 60px;
  border: 4px solid rgba(255, 255, 255, 0.3);
  border-top: 4px solid white;
  border-radius: 50%;
  animation: spin 1s linear infinite;
  margin-bottom: 1rem;
}

@keyframes spin {
  0% { transform: rotate(0deg); }
  100% { transform: rotate(360deg); }
}

.loading-text {
  color: white;
  font-size: 1.2rem;
  font-weight: 500;
}

/* Status Indicator */
.status-indicator {
  position: fixed;
  top: 2rem;
  left: 2rem;
  background: var(--card-background);
  backdrop-filter: blur(20px);
  border: 1px solid rgba(255, 255, 255, 0.2);
  border-radius: 25px;
  padding: 0.5rem 1rem;
  display: flex;
  align-items: center;
  gap: 0.5rem;
  font-size: 0.9rem;
  font-weight: 500;
  box-shadow: var(--shadow-light);
  z-index: 100;
  transition: var(--transition);
}

.status-dot {
  width: 8px;
  height: 8px;
  border-radius: 50%;
  background: var(--secondary-color);
  animation: statusPulse 2s ease-in-out infinite;
}

@keyframes statusPulse {
  0%, 100% { opacity: 1; }
  50% { opacity: 0.5; }
}

.status-indicator.connected .status-dot {
  background: var(--secondary-color);
}

.status-indicator.disconnected .status-dot {
  background: var(--accent-color);
}

.status-indicator.error .status-dot {
  background: #ef4444;
  animation: errorBlink 0.5s ease-in-out infinite;
}

@keyframes errorBlink {
  0%, 100% { opacity: 1; }
  50% { opacity: 0.3; }
}

/* Enhanced Icons */
.icon {
  display: inline-block;
  font-style: normal;
  font-size: 1.2em;
  margin-left: 0.5rem;
}

/* Container Layout Improvements */
.left-column,
.right-column {
  display: flex;
  flex-direction: column;
  height: 100%;
}

.list-container {
  flex: 1;
  display: flex;
  flex-direction: column;
  min-height: 0; /* Important for flex overflow */
}

.customer-list {
  flex: 1;
  min-height: 0; /* Important for flex overflow */
}

/* Enhanced Empty State */
.empty-state {
  text-align: center;
  color: var(--text-secondary);
  font-style: italic;
  padding: 3rem 2rem;
  opacity: 0.7;
  background: linear-gradient(135deg, #f8fafc, #f1f5f9);
  border-radius: 12px;
  border: 2px dashed rgba(107, 114, 128, 0.3);
  margin: 1rem 0;
}

/* Improved Responsive Design */
@media (max-width: 1200px) {
  .current-name {
    font-size: 2rem;
  }

  .customer-info {
    gap: 0.8rem;
  }

  .customer-number {
    width: 1.8rem;
    height: 1.8rem;
    font-size: 0.8rem;
  }
}

@media (max-width: 768px) {
  .status-indicator {
    top: 1rem;
    left: 1rem;
    font-size: 0.8rem;
    padding: 0.4rem 0.8rem;
  }

  .current-label {
    font-size: 1rem;
  }

  .current-name {
    font-size: 1.5rem;
  }

  .customer-info {
    gap: 0.6rem;
  }

  .customer-number {
    width: 1.5rem;
    height: 1.5rem;
    font-size: 0.7rem;
  }

  .count-badge {
    font-size: 0.8rem;
    padding: 0.2rem 0.6rem;
  }
}

/* Print Styles */
@media print {
  .status-indicator,
  .loading-overlay {
    display: none !important;
  }

  body {
    background: white !important;
  }

  .container {
    box-shadow: none !important;
  }
}




    </style>
</head>
<body>
    <div class="container">
        <!-- Left Column: Clock and Current Customer -->
        <div class="left-column">
            <!-- Digital Clock -->
            <div id="clock" role="timer" aria-live="polite" aria-label="{{ __('display.current_time') }}">
                --:--:--
            </div>

            <!-- Current Customer Section -->
            <div class="section-title" role="heading" aria-level="1">
                <span class="icon">📢</span>
                <span>{{ __('display.current_turn') }}</span>
            </div>
            <div id="current" class="current" role="status" aria-live="assertive" aria-label="{{ __('display.current_customer') }}">
                <div class="current-content">
                    <div class="current-label">{{ __('display.now_serving') }}:</div>
                    <div class="current-name">{{ __('display.loading_updates') }}</div>
                </div>
            </div>
        </div>

        <!-- Right Column: Waiting Lists -->
        <div class="right-column">
            <div class="section-title" role="heading" aria-level="1">
                <span class="icon">👥</span>
                <span>{{ __('display.upcoming') }}</span>
            </div>

            <div class="list-section">
                <!-- Walk-ins List -->
                <div class="list-container" role="region" aria-labelledby="walkins-title">
                    <h4 id="walkins-title" class="list-title">
                        <span class="icon">🧍</span>
                        <span>{{ __('display.without_appointment') }}</span>

                    </h4>
                    <ul id="walkins" class="customer-list" role="list" aria-label="{{ __('display.walkin_customers_list') }}">
                        <li class="empty-state">{{ __('display.no_waiting_customers') }}</li>
                    </ul>
                </div>

                <!-- Appointments List -->
                <div class="list-container" role="region" aria-labelledby="appointments-title">
                    <h4 id="appointments-title" class="list-title">
                        <span class="icon">📅</span>
                        <span>{{ __('display.with_appointment') }}</span>

                    </h4>
                    <ul id="appointments" class="customer-list" role="list" aria-label="{{ __('display.appointment_customers_list') }}">
                        <li class="empty-state">{{ __('display.no_scheduled_appointments') }}</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- Loading Overlay -->
    <div id="loading-overlay" class="loading-overlay" style="display: none;">
        <div class="loading-spinner"></div>
        <div class="loading-text">Loading Updates...</div>
    </div>
    
    <!-- Test Button (only visible during development) -->
    <button onclick="testWebSocket()" style="position: fixed; bottom: 20px; right: 20px; background: #667eea; color: white; border: none; padding: 10px 20px; border-radius: 8px; cursor: pointer; z-index: 1001; font-size: 14px;">
        Test WebSocket
    </button>


    @vite(['resources/js/bootstrap.js'])
    <script>
        // 🔧 Enhanced WebSocket Debugging
        console.log('🎯 Display page loaded at:', new Date().toISOString());
        console.log('🌐 User Agent:', navigator.userAgent);
        console.log('🔗 Page URL:', window.location.href);
        // ⏰ الساعة الرقمية
        function updateClock() {
            const now = new Date();
            const time = now.toLocaleTimeString('ar-MA', { hour: '2-digit', minute: '2-digit', second: '2-digit' });
            document.getElementById("clock").textContent = time;
        }
        setInterval(updateClock, 1000);
        updateClock();

        // 🖥️ ملء الشاشة تلقائياً
        document.addEventListener('click', function () {
            const el = document.documentElement;
            if (el.requestFullscreen) el.requestFullscreen();
            else if (el.webkitRequestFullscreen) el.webkitRequestFullscreen();
            else if (el.msRequestFullscreen) el.msRequestFullscreen();
        }, { once: true });

        // 📥 تحميل البيانات
        async function loadData() {
            const res = await fetch("{{ route('display.data', $device->device_token) }}");
            const data = await res.json();

            document.getElementById("current").textContent = data.current?.customer?.name ?? '{{ __('display.none') }}';

            const walkins = document.getElementById("walkins");
            const appointments = document.getElementById("appointments");

            walkins.innerHTML = '';
            appointments.innerHTML = '';

            data.walkins.forEach(item => {
                const li = document.createElement("li");
                li.classList.add( "list-box" );
                li.textContent = item.customer?.name ?? '{{ __('display.unknown') }}';
                walkins.appendChild(li);
            });

            data.appointments.forEach(item => {
                const li = document.createElement("li");
                li.classList.add( "list-box" );
                li.textContent = item.customer?.name ?? '{{ __('display.unknown') }}';
                appointments.appendChild(li);
            });
        }
        
        // 💓 Send heartbeat to track online status
        async function sendHeartbeat() {
            try {
                const response = await fetch("{{ route('display.heartbeat', $device->device_token) }}", {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    body: JSON.stringify({})
                });
                
                if (response.ok) {
                    console.log('💓 Heartbeat sent successfully');
                    updateConnectionStatus('connected');
                } else {
                    console.warn('⚠️ Heartbeat failed');
                    updateConnectionStatus('error');
                }
            } catch (error) {
                console.error('❌ Heartbeat error:', error);
                updateConnectionStatus('error');
            }
        }
        
        // 🔄 Update connection status indicator
        function updateConnectionStatus(status) {
            let statusIndicator = document.getElementById('status-indicator');
            if (!statusIndicator) {
                statusIndicator = document.createElement('div');
                statusIndicator.id = 'status-indicator';
                statusIndicator.className = 'status-indicator';
                statusIndicator.innerHTML = '<div class="status-dot"></div><span>WebSocket Status</span>';
                document.body.appendChild(statusIndicator);
            }
            
            statusIndicator.className = `status-indicator ${status}`;
            
            // Update status text based on connection
            const statusText = statusIndicator.querySelector('span');
            switch(status) {
                case 'connected':
                    statusText.textContent = 'WebSocket Connected';
                    break;
                case 'error':
                    statusText.textContent = 'WebSocket Error';
                    break;
                default:
                    statusText.textContent = 'WebSocket Status';
            }
        }


        // 📡 WebSocket Connection with Laravel Echo
        document.addEventListener('DOMContentLoaded', function () {
            const tenantId = "{{ $tenantId }}";
            console.log('🔍 WebSocket setup starting for tenant:', tenantId);
            console.log('🔍 Window.Echo available:', !!window.Echo);
            console.log('🔍 Window.Pusher available:', !!window.Pusher);

            if (window.Echo) {
                console.log('🔧 Connecting to WebSocket channels for tenant:', tenantId);
                console.log('🔧 Echo configuration:', window.Echo.options);
                
                // Listen for queue updates on public channel (displays don't need authentication)
                window.Echo.channel(`waiting-room.${tenantId}`)
                    .listen('.QueueUpdated', (e) => {
                        console.log('🔁 Queue Updated via WebSocket:', e);
                        loadData();
                        updateConnectionStatus('connected');
                    })
                    .error((error) => {
                        console.error('❌ WebSocket Channel Error:', error);
                        updateConnectionStatus('error');
                    });

                // Listen for display updates on public channel
                window.Echo.channel(`display.${tenantId}`)
                    .listen('.DisplayUpdated', (e) => {
                        console.log('🖥️ Display Updated via WebSocket:', e);
                        loadData();
                        updateConnectionStatus('connected');
                    });

          
                    
                console.log('✅ WebSocket connection established');
            } else {
                console.warn('⚠️ Echo not defined. WebSocket not available, using polling fallback.');
                // Fallback to polling if WebSocket is not available
                setInterval(() => {
                    console.log('📊 Polling for updates (WebSocket fallback)');
                    loadData();
                }, 30000); // Poll every 30 seconds
            }

            // Initial data load
            loadData();
            
            // Start heartbeat (every 60 seconds)
            sendHeartbeat(); // Send initial heartbeat
            setInterval(sendHeartbeat, 60000); // Send heartbeat every minute
            
            // Additional polling as backup (even with WebSocket)
            // This ensures updates even if WebSocket temporarily fails
            setInterval(() => {
                console.log('🔄 Periodic data refresh (backup)');
                loadData();
            }, 120000); // Poll every 2 minutes as backup
        });
        
        // Test WebSocket function
        async function testWebSocket() {
            try {
                console.log('🧪 Testing WebSocket connection...');
                const response = await fetch('/test-websocket/{{ $tenantId }}');
                const data = await response.json();
                console.log('🚀 WebSocket test result:', data);
                
                if (data.success) {
                    // Show temporary success message
                    const testButton = document.querySelector('button[onclick="testWebSocket()"]');
                    const originalText = testButton.textContent;
                    testButton.textContent = '✅ Events Sent!';
                    testButton.style.background = '#28a745';
                    
                    setTimeout(() => {
                        testButton.textContent = originalText;
                        testButton.style.background = '#667eea';
                    }, 3000);
                } else {
                    console.error('❌ WebSocket test failed:', data.error);
                }
            } catch (error) {
                console.error('❌ WebSocket test error:', error);
            }
        }

    </script>
</body>
</html>
