@extends("layouts.app")

@section("content")
<meta name="csrf-token" content="{{ csrf_token() }}">

<div class="container mt-4">
    <div class="row justify-content-center">
        <div class="col-md-8">

            <div class="card mb-4">
                <div class="card-header">{{ __('customers.registered_customers') }}</div>
                <div class="card-body">


                    @if ($customers->count())
                        <table id="customers-table" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>{{ __('customers.name') }}</th>
                                    <th>{{ __('customers.phone') }}</th>
                                    <th>{{ __('customers.actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($customers as $customer)
                                    <tr>
                                        <td>{{ $customer->name }}</td>
                                        <td>{{ $customer->phone }}</td>
                                        <td>
                                            <button class="btn btn-sm btn-info load-customer" data-id="{{ $customer->id }}">{{ __('customers.load') }}</button>
                                            <button class="btn btn-sm btn-danger delete-customer" data-id="{{ $customer->id }}">{{ __('customers.delete') }}</button>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    @else
                        <p class="text-center text-muted">{{ __('customers.no_results') }}</p>
                    @endif

                </div>
            </div>
        </div>
        <div class="col-md-4">
                    <!-- {{ __('customers.customer_form') }} -->
                    <div class="card">
                        <div class="card-header">{{ __('customers.add_new_customer') }}</div>

                        <div class="card-body">
                            @if (session("success"))
                                <div class="alert alert-success" role="alert">
                                    {{ session("success") }}
                                </div>
                            @endif

                            @if ($errors->any())
                                <div class="alert alert-danger">
                                    <ul>
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif

                            <form method="POST" action="{{ route("customers.store") }}">
                                @csrf
                                <input type="hidden" id="customer_id" name="customer_id">
                                <div class="mb-3 row">
                                    <label for="name" class="col-md-3 col-form-label">{{ __('customers.name') }}</label>
                                    <div class="col-md-9">
                                        <input id="name" type="text" class="form-control" name="name" value="{{ old("name") }}" required>
                                    </div>
                                </div>

                                <div class="mb-3 row">
                                    <label for="phone" class="col-md-3 col-form-label">{{ __('customers.phone') }}</label>
                                    <div class="col-md-9">
                                        <input id="phone" type="text" class="form-control" name="phone" value="{{ old("phone") }}">
                                    </div>
                                </div>
                                <div class="mb-3 row">
                                    <label for="visit_type" class="col-md-3 col-form-label">{{ __('customers.visit_type') }}</label>
                                    <div class="col-md-9">
                                        <select id="visit_type" class="form-control" name="visit_type" required>
                                            <option value="">{{ __('customers.select_visit_type') }}</option>
                                            @foreach ($visitTypes as $vtype)
                                            <option value="{{ $vtype->name }}" {{ old('visit_type') == 'consultation' ? 'selected' : '' }}>{{ $vtype->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>


                                <div class="text-end">
                                    <button type="submit" class="btn btn-primary">{{ __('customers.add_customer') }}</button>
                                </div>
                            </form>
                        </div>
                    </div>
        </div>
    </div>
</div>

@endsection
