@extends('layouts.app')

@push('style')
    <link href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.11/main.min.css" rel="stylesheet">

@endpush

@section('content')
<div class="container mt-4">
    <h2 class="mb-3">📅 {{ __('calendar.appointments_calendar') }}</h2>
    <div id="calendar" style="min-height: 600px;"></div>
</div>
@endsection
@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.11/index.global.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const calendarEl = document.getElementById('calendar');

        const calendar = new FullCalendar.Calendar(calendarEl, {
            initialView: 'timeGridWeek',
            locale: 'ar',
            timeZone: 'local',
            editable: true,
            headerToolbar: {
                left: 'prev,next today',
                center: 'title',
                right: 'dayGridMonth,timeGridWeek,timeGridDay'
            },
            events: '/calendar/events',
            eventDrop: function(info) {
                fetch(`/calendar/update/${info.event.id}`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    },
                    body: JSON.stringify({
                        start: info.event.start.toISOString()
                    })
                }).then(res => res.json())
                  .then(data => {
                    if (!data.success) {
                        alert('{{ __('calendar.update_failed') }}');
                        info.revert();
                    }
                }).catch(() => {
                    alert('{{ __('calendar.error_occurred') }}');
                    info.revert();
                });
            }
        });

        calendar.render();
    });
</script>
@endpush
