<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class SubscriptionPlanSeeder extends Seeder
{
    public function run(): void
    {
        DB::table('subscription_plans')->insert([
            [
                'name' => 'Free',
                'price' => 0,
                'max_users' => 1,
                'max_customers' => 20,
                'max_appointments' => 10,
                'sms_limit' => 0,
                'features' => json_encode([
                    'support' => 'email_only',
                    'branding' => 'powered_by_project',
                    'stats' => false,
                    'customer_crud' => false,
                    'user_management' => false
                ]),
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'Basic',
                'price' => 99,
                'max_users' => 2,
                'max_customers' => 200,
                'max_appointments' => 50,
                'sms_limit' => 0,
                'features' => json_encode([
                    'support' => 'weekday_email',
                    'branding' => 'powered_by_project',
                    'stats' => 'basic',
                    'customer_crud' => ['add', 'edit'],
                    'user_management' => false
                ]),
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'Pro',
                'price' => 249,
                'max_users' => 5,
                'max_customers' => 1000,
                'max_appointments' => null,
                'sms_limit' => 100,
                'features' => json_encode([
                    'support' => 'whatsapp',
                    'branding' => 'no_branding',
                    'stats' => 'full',
                    'customer_crud' => ['add', 'edit', 'delete'],
                    'user_management' => true,
                    'custom_roles' => true
                ]),
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'Business',
                'price' => 499,
                'max_users' => 15,
                'max_customers' => null,
                'max_appointments' => null,
                'sms_limit' => 500,
                'features' => json_encode([
                    'support' => 'dedicated',
                    'branding' => 'custom_branding',
                    'stats' => 'full_advanced',
                    'customer_crud' => ['add', 'edit', 'delete'],
                    'user_management' => true,
                    'custom_roles' => true,
                    'white_label' => true
                ]),
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
        ]);
    }
}
