<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('short_links', function (Blueprint $table) {
            $table->id();
            $table->text('original_url'); // The full URL to redirect to
            $table->string('short_code', 10)->unique(); // Short code for the URL (e.g., 'abc123')
            $table->unsignedBigInteger('tenant_id')->nullable()->index(); // For multi-tenancy
            $table->string('usage_type', 50)->default('display_pairing'); // Type: display_pairing, queue_public, etc.
            $table->timestamp('expires_at')->nullable(); // Optional expiration date
            $table->unsignedInteger('click_count')->default(0); // Track usage
            $table->json('metadata')->nullable(); // Additional data (display_id, etc.)
            $table->string('created_by')->nullable(); // User who created it
            $table->timestamps();
            
            // Indexes for better performance
            $table->index(['tenant_id', 'usage_type']);
            $table->index(['expires_at']);
            $table->index(['created_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('short_links');
    }
};
