<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('display_devices', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('tenant_id')->nullable()->index();
            $table->string('device_token', 64)->unique(); // يُستخدم في الرابط
            $table->string('name')->nullable();           // اسم وصفي للشاشة (اختياري)
            $table->string('last_ip')->nullable();
            $table->timestamp('paired_at')->nullable();
            $table->timestamps();
        });
    }
    public function down(): void {
        Schema::dropIfExists('display_devices');
    }
};
