<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('appointment_settings', function (Blueprint $table) {
            $table->id();
            $table->integer('interval_minutes')->default(15); // فترة بين المواعيد بالدقائق
            $table->time('start_time')->default('08:00'); // وقت بداية العمل
            $table->time('end_time')->default('18:00'); // وقت نهاية العمل
            $table->json('working_days')->nullable(); // أيام العمل (1=الاثنين, 7=الأحد)
            $table->integer('max_appointments_per_slot')->default(1); // عدد المواعيد المسموح بها في كل فترة
            $table->boolean('allow_same_day_booking')->default(true); // السماح بحجز نفس اليوم
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('appointment_settings');
    }
};
