<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('waiting_queue', function (Blueprint $table) {
            $table->id();
            $table->foreignId('customer_id')->constrained()->onDelete('cascade');
            $table->enum('queue_type', ['appointment', 'walk_in']);
            $table->dateTime('appointment_time')->nullable();
            $table->dateTime('arrival_time')->useCurrent();
            $table->enum('status', ['waiting', 'serving', 'completed', 'cancelled'])->default('waiting');
            $table->integer('priority_score')->default(0);
            $table->integer('estimated_wait_time')->nullable();
            $table->text('notes')->nullable();
            $table->foreignId('served_by')->nullable()->constrained('users')->onDelete('set null');
            $table->dateTime('served_at')->nullable();
            $table->dateTime('completed_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('waiting_queue');
    }
};
