<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;


class Tenant extends Model
{


    protected $fillable = [
        'name',
        'timezone',
        'email',
        'phone',
        'address',
        'logo',
        'uuid',
        'subscription_plan_id',
        'expires_at',
    ];

    public function subscriptionPlan()
    {
        return $this->belongsTo(SubscriptionPlan::class);
    }

    public function users()
    {
        return $this->hasMany(User::class);
    }

    protected static function booted()
{
    static::creating(function ($tenant) {
        if (empty($tenant->uuid)) {
            $tenant->uuid = Str::uuid()->toString();
        }
    });
}

public function visitTypes()
{
    return $this->hasMany(VisitType::class);
}

}
