<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;


class SubscriptionPlan extends Model
{
    use HasFactory;

    protected $fillable = [
        'name', 'price', 'price', 'max_users', 'max_customers','max_appointments', 'sms_limit', 'features'
    ];

    public function permissions()
    {
        return $this->belongsToMany(Permission::class, 'permission_plan', 'plan_id', 'permission_id');
    }



}
