<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;
use Carbon\Carbon;

class QrLoginToken extends Model
{
    use HasFactory;
    
    protected $fillable = [
        'token',
        'user_id', 
        'status',
        'ip_address',
        'user_agent',
        'expires_at',
        'scanned_at',
        'authenticated_at'
    ];
    
    protected $casts = [
        'expires_at' => 'datetime',
        'scanned_at' => 'datetime',
        'authenticated_at' => 'datetime',
    ];
    
    public function user()
    {
        return $this->belongsTo(User::class);
    }
    
    public static function generateToken()
    {
        return Str::random(32) . time();
    }
    
    public function isExpired()
    {
        return $this->expires_at->isPast();
    }
    
    public function isPending()
    {
        return $this->status === 'pending' && !$this->isExpired();
    }
    
    public function markAsScanned($userId = null)
    {
        $this->update([
            'status' => 'scanned',
            'user_id' => $userId,
            'scanned_at' => now()
        ]);
    }
    
    public function markAsAuthenticated()
    {
        $this->update([
            'status' => 'authenticated',
            'authenticated_at' => now()
        ]);
    }
    
    public function markAsExpired()
    {
        $this->update([
            'status' => 'expired'
        ]);
    }
}
