<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;


class Permission extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'tenant_id',
        'group',
    ];

    public function roles()
    {
        return $this->belongsToMany(Role::class, 'permission_role');
    }

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }

    public function SubscriptionPlan()
{
    return $this->belongsToMany(SubscriptionPlan::class, 'permission_plan');
}
}
