<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;
use App\Models\Scopes\TenantScope;


class DisplayDevice extends Model
{


    protected $fillable = [
        'tenant_id','device_token','name','last_ip','is_authorized','paired_at','last_seen_at',
        'pairing_status','pairing_session_id','pairing_started_at','pairing_user_agent',
    ];
    
    protected $casts = [
        'paired_at' => 'datetime',
        'last_seen_at' => 'datetime',
        'pairing_started_at' => 'datetime',
    ];

    protected static function booted()
    {
        static::addGlobalScope(new TenantScope);

        static::creating(function ($device) {
            if (empty($device->device_token)) {
                $device->device_token = Str::random(40);
            }
            if (empty($device->tenant_id )) {
                $device->tenant_id  = app('currentTenant')->id;
            }
        });

        static::creating(function ($model) {
            if (app()->bound('currentTenant') && empty($model->tenant_id)) {
                $model->tenant_id = app('currentTenant')->id;
            }
        });
    }

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }

}
