<?php

namespace App\Http\Controllers;

use App\Models\VisitType;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class VisitTypeController extends Controller
{
    // قائمة الأنواع الخاصة بالمستأجر الحالي
    public function index()
    {
        $visitTypes = VisitType::where('tenant_id', tenant('id')->id)->get();
        return view('visit_types.index', compact('visitTypes'));
    }

    // عرض نموذج إضافة نوع جديد
    public function create()
    {
        return view('visit_types.create');
    }

    // تخزين نوع جديد
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
        ]);

        VisitType::create([
            'name' => $request->name,
            'tenant_id' => tenant('id')->id,
        ]);

        return redirect()->route('visit_types.index')
            ->with('success', __('visit_types.visit_type_created'));
    }

    // عرض نموذج تعديل نوع موجود
    public function edit(VisitType $visitType)
    {
        $this->authorizeTenant($visitType);
        return view('visit_types.edit', compact('visitType'));
    }

    // تحديث نوع موجود
    public function update(Request $request, VisitType $visitType)
    {
        $this->authorizeTenant($visitType);

        $request->validate([
            'name' => 'required|string|max:255',
        ]);

        $visitType->update([
            'name' => $request->name,
        ]);

        return redirect()->route('visit_types.index')
            ->with('success', __('visit_types.visit_type_updated'));
    }

    // حذف نوع
    public function destroy(VisitType $visitType)
    {
        $this->authorizeTenant($visitType);
        $visitType->delete();

        return redirect()->route('visit_types.index')
            ->with('success', __('visit_types.visit_type_deleted'));
    }

    // Check tenant authorization
    private function authorizeTenant(VisitType $visitType)
    {
        if ($visitType->tenant_id !== tenant('id')->id) {
            abort(403, __('visit_types.unauthorized_access'));
        }
    }
}
