<?php

namespace App\Http\Controllers;

use App\Models\AppointmentSetting;
use App\Models\DisplayDevice;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class SettingsController extends Controller
{
    public function index()
{
    $settings = [
        [
            'icon' => 'fa-clock',
            'title' => __('settings.working_hours'),
            'description' => __('settings.working_hours_desc'),
            'route' => route('settings.appointment'),
            'color' => 'primary'
        ],/*
        [
            'icon' => 'fa-calendar-check',
            'title' => __('lang.appointments'),
            'description' => __('settings.appointment_management_desc'),
            'route' => route('appointments.create'),
            'color' => 'success'
        ],*/
        [
            'icon' => 'fa-tv',
            'title' => __('settings.displays'),
            'description' => __('settings.displays_desc'),
            'route' => route('settings.displays'),
            'color' => 'info'
        ],
        [
            'icon' => 'fa-users-cog',
            'title' => __('settings.roles_permissions'),
            'description' => __('settings.roles_permissions_desc'),
            'route' => route('roles.index'),
            'color' => 'warning'
        ],
        [
            'icon' => 'fa-gears',
            'title' => __('settings.services'),
            'description' => __('settings.visit_types'),
            'route' => route('visit_types.index'),
            'color' => 'danger'
        ],
    ];

    return view('settings.index', compact('settings'));
}

    public function appointmentSettings()
    {
        $settings = AppointmentSetting::first();
        return view('settings.appointment', compact('settings'));
    }

    public function saveAppointmentSettings(Request $request)
    {
        $data = $request->validate([
            'interval_minutes' => 'required|integer|min:1',
            'start_time' => 'required',
            'end_time' => 'required',
            'working_days' => 'required|array',
        ]);

        AppointmentSetting::updateOrCreate([], $data);
        return back()->with('success', __('settings.appointment_settings_saved'));
    }

    public function displays()
    {
        $displays = DisplayDevice::all();
        return view('settings.displays', compact('displays'));
    }

    public function createDisplay(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255'
        ]);
        
        $display = DisplayDevice::create([
            'name' => $request->name,
            'device_token' => Str::random(32),
            'tenant_id' => auth()->user()->tenant_id,
            'is_authorized' => 'non',
            'last_ip' => $request->ip()
        ]);
        
        if ($request->expectsJson()) {
            return response()->json([
                'success' => true,
                'message' => __('settings.display_created'),
                'display' => $display
            ]);
        }
        
        return back()->with('success', __('settings.display_created'));
    }



}
