<?php

namespace App\Http\Controllers;

use App\Models\Permission;
use App\Models\Role;
use Illuminate\Http\Request;
use DB;

class RoleController extends Controller
{
    public function index()
    {
        $tenantId = auth()->user()->tenant_id;
        $roles = Role::where('tenant_id', $tenantId)->get();
        return view('roles.index', compact('roles'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|unique:roles,name',
        ]);

        Role::create([
            'name' => $request->name,
            'tenant_id' => auth()->user()->tenant_id,
        ]);

        return back()->with('success', 'تمت إضافة الدور بنجاح.');
    }

    public function update(Request $request, Role $role)
    {
        $request->validate([
            'name' => 'required',
        ]);

        if ($role->can_supprimer == "oui") {

        $role->update([
            'name' => $request->name,
        ]);

        return back()->with('success', 'تم تعديل الدور بنجاح.');
        }
        else
        {
            return back()->with('error', 'لا يكن تعديل هذا الدور');
        }
    }

    public function destroy(Role $role)
    {
        $currentTenantId = auth()->user()->tenant_id;

        // التحقق من وجود مستخدمين لهذا الدور في نفس الـ tenant
        $hasUsers = \DB::table('role_user')
            ->join('users', 'users.id', '=', 'role_user.user_id')
            ->where('role_user.role_id', $role->id)
            ->where('role_user.tenant_id', $currentTenantId)
            ->exists();

        if ($hasUsers) {
            return back()->with('error', 'لا يمكن حذف الدور لأنه مرتبط بمستخدمين.');
        }

        if ($role->can_supprimer === "non") {
            return back()->with('error', 'لا يمكن حذف هذا الدور.');
        }

        $role->permissions()->detach();
        $role->delete();

        return back()->with('success', 'تم حذف الدور بنجاح.');
    }


    public function editPermissions(Role $role)
{
    $tenantId = auth()->user()->tenant_id;

    // التأكد أن الدور تابع للمستأجر الحالي
    if ($role->tenant_id != $tenantId) {
        abort(403);
    }

    $permissions = Permission::all(); // أو حسب نظامك
    //$rolePermissions = $role->permissions->pluck('id')->toArray();
    $rolePermissions = [];
try {

    $roleUser = DB::table('role_user')
    ->where('role_id', $role->id)
    ->where('tenant_id',$tenantId)
    ->first();

    $rolePermissions = DB::table('permission_role')
    ->where('role_id', $roleUser->id)
    ->pluck('permission_id')
    ->toArray();
} catch (\Throwable $th) {
    //throw $th;
}


    return view('roles.edit-permissions', compact('role', 'permissions', 'rolePermissions'));
}

public function updatePermissions(Request $request, Role $role)
{

    $tenantId = auth()->user()->tenant_id;

    if ($role->tenant_id != $tenantId) {
        abort(403);
    }
/*
    $permissions = $request->input('permissions', []);

    $role->permissions()->sync($permissions);

    return redirect()->route('roles.index')->with('success', 'تم تحديث الصلاحيات بنجاح.');
*/

    $roleId = $role->id; // ID الدور الأساسي في جدول roles
$permissions = $request->input('permissions', []);

// 1. الحصول على جميع سجلات role_user لهذا الدور
$roleUserRecords = DB::table('role_user')
    ->where('role_id', $roleId)
    ->get();

// 2. تحديث الصلاحيات لكل سجل role_user
foreach ($roleUserRecords as $roleUser) {
    DB::table('permission_role')
        ->where('role_id', $roleUser->id)
        ->delete(); // حذف الصلاحيات القديمة

    // إضافة الصلاحيات الجديدة
    foreach ($permissions as $permissionId) {
        DB::table('permission_role')->insert([
            'role_id' => $roleUser->id,
            'permission_id' => $permissionId,
            'created_at' => now(),
            'updated_at' => now()
        ]);
    }
}

return redirect()->route('roles.index')->with('success', 'تم تحديث الصلاحيات بنجاح.');
}
}
