<?php
namespace App\Http\Controllers;

use App\Models\WaitingQueue;
use App\Models\Tenant;
use App\Models\Customer;
use Illuminate\Support\Carbon;
use Illuminate\Http\Request;
use DB;


class QueueController extends Controller
{

    public function showForm($uuid)
    {
        return view('queue.check', ['uuid' => $uuid]);
    }

    public function check(Request $request, $uuid)
    {
        $tenant = Tenant::where('uuid', $uuid)->firstOrFail();
        app()->instance('currentTenant', $tenant);

        $phone = $request->input('phone');

        $customer = Customer::where('tenant_id', $tenant->id)->where('phone', $phone)->first();

        if (!$customer) {
            return back()->with('error', 'رقم الهاتف غير موجود');
        }

        $today = today();

        // العثور على الدور الحالي لهذا الزبون
        $entry = WaitingQueue::where('tenant_id', $tenant->id)
            ->where('customer_id', $customer->id)
            ->where('status', 'waiting')
            ->whereDate(DB::raw("IF(type = 'walk-in', arrival_time, appointment_time)"), $today)
            ->orderBy('appointment_time')
            ->first();

        if (!$entry) {
            return back()->with('error', 'أنت غير مسجل في قائمة الانتظار اليوم');
        }

        $preceding = collect(); // تهيئة

        if ($entry->type === 'walk-in') {
            $preceding = WaitingQueue::where('tenant_id', $tenant->id)
                ->with('customer')
                ->where('type', 'walk-in')
                ->where('status', 'waiting')
                ->whereDate('arrival_time', $today)
                ->where('position', '<', $entry->position)
                //->where('arrival_time', '<', $entry->arrival_time)
                ->orderBy('position')
                ->get();
        }

        return view('queue.result', [
            'entry' => $entry,
            'preceding' => $preceding,
        ]);
    }

    public function showPublicQueue($uuid)
{
    $tenant = Tenant::where('uuid', $uuid)->firstOrFail();

    app()->instance('currentTenant', $tenant);

    $waitingList = WaitingQueue::where('tenant_id', $tenant->id)
        ->where('status', 'waiting')
        ->whereDate('arrival_time', today())
        ->orderBy('position')
        ->get();

    return view('queue.queue', compact('tenant', 'waitingList'));
}

public function joinQueue(Request $request, $uuid)
{
    $tenant = Tenant::where('uuid', $uuid)->firstOrFail();

    $request->validate([
        'name' => 'required|string|max:255'
    ]);

    $customer = Customer::create([
        'name' => $request->name,
        'tenant_id' => $tenant->id,
    ]);

    $entry = WaitingQueue::create([
        'tenant_id' => $tenant->id,
        'customer_id' => $customer->id,
        'status' => 'waiting',
    ]);

    return redirect()->route('public.queue', $uuid)->with('success', 'تم تسجيلك في الطابور! رقمك هو ' . ($entry->id));
}

}
