<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Permission;
use App\Models\SubscriptionPlan;

class PlanPermissionController extends Controller
{
    public function listPlans()
    {
        $plans = SubscriptionPlan::all();
        return view('plans.permissions.index', compact('plans'));
    }

    public function edit(SubscriptionPlan $plan)
    {
        $permissions = Permission::all()->groupBy('group');
        $selectedPermissions = $plan->permissions->pluck('id')->toArray();

        return view('plans.permissions.edit', compact('plan', 'permissions', 'selectedPermissions'));
    }

    public function update(Request $request, SubscriptionPlan $plan)
    {
        $plan->permissions()->sync($request->input('permissions', []));
        return redirect()->route('plan-permissions.index')->with('success', 'Permissions updated.');
    }
}

